"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskLevelsPrivilegedUsersQueryBody = exports.RISK_LEVELS_PRIVILEGED_USERS_QUERY_ID = void 0;
var _search_strategy = require("../../../../../common/search_strategy");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRiskLevelsPrivilegedUsersQueryBody = namespace => `
| WHERE ${_search_strategy.RiskScoreFields.userName} IS NOT NULL
${(0, _helpers.getPrivilegedMonitorUsersJoin)(namespace)}
| STATS count = COUNT_DISTINCT(${_search_strategy.RiskScoreFields.userName}) BY ${_search_strategy.RiskScoreFields.userRisk}
| RENAME ${_search_strategy.RiskScoreFields.userRisk} AS level`;
exports.getRiskLevelsPrivilegedUsersQueryBody = getRiskLevelsPrivilegedUsersQueryBody;
const RISK_LEVELS_PRIVILEGED_USERS_QUERY_ID = exports.RISK_LEVELS_PRIVILEGED_USERS_QUERY_ID = 'risk_levels_privileged_users';