"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActivityPrivilegedUsersPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _Either = require("fp-ts/Either");
var _use_global_time = require("../../../../../common/containers/use_global_time");
var _query_toggle = require("../../../../../common/containers/query_toggle");
var _links = require("../../../../../common/components/links");
var _header_section = require("../../../../../common/components/header_section");
var _constants = require("./constants");
var _esql_dashboard_panel = require("../../../privileged_user_monitoring_onboarding/components/esql_dashboard_panel/esql_dashboard_panel");
var _hooks = require("./hooks");
var _types = require("./types");
var _kibana = require("../../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/privileged_user_activity/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PICK_VISUALIZATION_LEGEND = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.pickVisualizationLegend', {
  defaultMessage: 'Select a visualization to display'
});
const TITLE = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.title', {
  defaultMessage: 'Privileged user activity'
});
const UserActivityPrivilegedUsersPanel = ({
  sourcererDataView
}) => {
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(_constants.PRIVILEGED_USER_ACTIVITY_QUERY_ID);
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const [selectedToggleOption, setToggleOption] = (0, _react.useState)(_types.VisualizationToggleOptions.GRANTED_RIGHTS);
  const {
    getAppUrl
  } = (0, _kibana.useNavigation)();
  const {
    getLensAttributes,
    columns,
    generateVisualizationQuery,
    generateTableQuery
  } = (0, _hooks.usePrivilegedUserActivityParams)(selectedToggleOption, sourcererDataView);
  const stackByOptions = (0, _hooks.useStackByOptions)(selectedToggleOption);
  const stackByLabel = _i18n.i18n.translate('xpack.securitySolution.genericDashboard.stackBy.label', {
    defaultMessage: 'Stack by'
  });
  const setSelectedChartOptionCallback = (0, _react.useCallback)(value => {
    setSelectedStackByOption(value !== null && value !== void 0 ? value : stackByOptions[0].value);
  }, [stackByOptions]);
  const defaultStackByOption = stackByOptions[0];
  const [selectedStackByOption, setSelectedStackByOption] = (0, _react.useState)(defaultStackByOption.value);
  const toggleOptions = (0, _hooks.useToggleOptions)();
  const tableQuery = generateTableQuery('@timestamp', 'DESC', 100);
  const getOrEmptyString = (0, _Either.getOrElse)(() => '');
  const discoverPath = (0, _hooks.useDiscoverPath)(getOrEmptyString(tableQuery));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    "data-test-subj": "severity-level-panel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    id: _constants.PRIVILEGED_USER_ACTIVITY_QUERY_ID,
    showInspectButton: false,
    title: TITLE,
    titleSize: "m",
    outerDirection: "column",
    hideSubtitle: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, (0, _Either.isRight)(tableQuery) && /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    href: getAppUrl({
      appId: 'discover',
      path: discoverPath
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.linkDescription",
    defaultMessage: "View all events",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }))), toggleStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    options: toggleOptions,
    idSelected: selectedToggleOption,
    onChange: id => {
      setToggleOption(id);
      setSelectedStackByOption(defaultStackByOption.value);
    },
    legend: PICK_VISUALIZATION_LEGEND,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, stackByOptions.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    onChange: setSelectedChartOptionCallback,
    options: stackByOptions,
    prepend: stackByLabel,
    valueOfSelected: selectedStackByOption,
    hasDividers: true,
    itemLayoutAlign: "top",
    "aria-label": stackByLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_esql_dashboard_panel.EsqlDashboardPanel, {
    title: TITLE,
    stackByField: selectedStackByOption,
    timerange: {
      from,
      to
    },
    getLensAttributes: getLensAttributes,
    generateVisualizationQuery: generateVisualizationQuery,
    generateTableQuery: generateTableQuery,
    columns: columns,
    pageSize: _constants.PAGE_SIZE,
    showInspectTable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  })));
};
exports.UserActivityPrivilegedUsersPanel = UserActivityPrivilegedUsersPanel;