"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTriggeredTile = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _Either = require("fp-ts/Either");
var _i18n = require("@kbn/i18n");
var _esql_query = require("./esql_query");
var _key_insights_tile = require("../common/key_insights_tile");
var _use_signal_index = require("../../../../../../detections/containers/detection_engine/alerts/use_signal_index");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/key_insights_panel/alerts_triggered_tile/alerts_triggered_tile.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertsTriggeredTile = ({
  spaceId
}) => {
  const {
    signalIndexName: alertsIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  return /*#__PURE__*/_react.default.createElement(_key_insights_tile.KeyInsightsTile, {
    title: _i18n.i18n.translate('xpack.securitySolution.privmon.alertsTriggered.title', {
      defaultMessage: 'Alerts triggered'
    }),
    label: _i18n.i18n.translate('xpack.securitySolution.privmon.alertsTriggered.label', {
      defaultMessage: 'Alerts triggered'
    }),
    getEsqlQuery: namespace => (0, _Either.right)((0, _esql_query.getAlertsTriggeredEsqlCount)(namespace, alertsIndexName)),
    id: "privileged-user-monitoring-alerts-triggered",
    spaceId: spaceId,
    inspectTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.privmon.alertsTriggered.inspectTitle",
      defaultMessage: "Alerts triggered",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  });
};
exports.AlertsTriggeredTile = AlertsTriggeredTile;