"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceFieldToText = exports.getEntityType = exports.EntityIconByType = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../common/entity_analytics/types");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_store/helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getEntityType = record => {
  var _record$entity$Engine;
  // Looking at `entity.type` to keep backward compatibility
  const entityType = ((_record$entity$Engine = record.entity.EngineMetadata) === null || _record$entity$Engine === void 0 ? void 0 : _record$entity$Engine.Type) || record.entity.type;
  if (!entityType || !Object.values(_types.EntityType).includes(entityType)) {
    throw new Error(`Unexpected entity: ${JSON.stringify(record)}`);
  }
  return _types.EntityType[entityType];
};
exports.getEntityType = getEntityType;
const EntityIconByType = exports.EntityIconByType = {
  [_types.EntityType.user]: 'user',
  [_types.EntityType.host]: 'storage',
  [_types.EntityType.service]: 'node',
  [_types.EntityType.generic]: 'globe'
};
const sourceFieldToText = source => {
  if (source.match(`^${_constants.RISK_SCORE_INDEX_PATTERN}`)) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.helpers.sourceField.riskDescription",
      defaultMessage: "Risk",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 7
      }
    });
  }
  if (source.match(`^${_constants.ASSET_CRITICALITY_INDEX_PATTERN}`)) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.helpers.sourceField.criticalityDescription",
      defaultMessage: "Asset Criticality",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.entityStore.helpers.sourceField.eventDescription",
    defaultMessage: "Events",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  });
};
exports.sourceFieldToText = sourceFieldToText;