"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsLearnMoreLink = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _kibana = require("../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_analytics_learn_more_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EntityAnalyticsLearnMoreLinkComponent = ({
  title
}) => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const entityAnalyticsLinks = docLinks.links.securitySolution.entityAnalytics;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    rel: "noopener nofollow noreferrer",
    href: entityAnalyticsLinks.entityRiskScoring,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }, title ? title : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.learnMore",
    defaultMessage: "Learn more about entity risk scoring",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 9
    }
  }));
};
const EntityAnalyticsLearnMoreLink = exports.EntityAnalyticsLearnMoreLink = /*#__PURE__*/_react.default.memo(EntityAnalyticsLearnMoreLinkComponent);
EntityAnalyticsLearnMoreLink.displayName = 'EntityAnalyticsLearnMoreLink';