"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetCriticalityOptions = exports.AssetCriticalityTitle = exports.AssetCriticalitySelector = exports.AssetCriticalityAccordion = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _types = require("../../../../common/entity_analytics/types");
var _translations = require("./translations");
var _asset_criticality_badge = require("./asset_criticality_badge");
var _use_asset_criticality = require("./use_asset_criticality");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/asset_criticality/asset_criticality_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AssetCriticalitySelectorComponent = ({
  criticality,
  entity,
  compressed = false
}) => {
  var _criticality$query$da, _criticality$privileg, _criticality$privileg2, _criticality$query$da2;
  const [visible, toggleModal] = (0, _useToggle.default)(false);
  const sFontSize = (0, _eui.useEuiFontSize)('s').fontSize;
  const onSave = value => {
    criticality.mutation.mutate({
      criticalityLevel: value,
      idField: _types.EntityTypeToIdentifierField[entity.type],
      idValue: entity.name
    });
    toggleModal(false);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, criticality.query.isLoading || criticality.mutation.isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    "data-test-subj": "asset-criticality-selector-loading",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "spaceBetween",
    "data-test-subj": "asset-criticality-selector",
    wrap: false,
    gutterSize: 'xs',
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_asset_criticality_badge.AssetCriticalityBadge, {
    criticalityLevel: (_criticality$query$da = criticality.query.data) === null || _criticality$query$da === void 0 ? void 0 : _criticality$query$da.criticality_level,
    dataTestSubj: "asset-criticality-level",
    className: (0, _css.css)`
                font-size: ${sFontSize};
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  })), compressed && ((_criticality$privileg = criticality.privileges.data) === null || _criticality$privileg === void 0 ? void 0 : _criticality$privileg.has_write_permissions) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "asset-criticality-change-btn",
    iconSize: "s",
    iconType: 'pencil',
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.assetCriticality.compressedButtonArialLabel', {
      defaultMessage: 'Change asset criticality'
    }),
    onClick: () => toggleModal(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 15
    }
  })), !compressed && ((_criticality$privileg2 = criticality.privileges.data) === null || _criticality$privileg2 === void 0 ? void 0 : _criticality$privileg2.has_write_permissions) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      flexGrow: 'unset'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "asset-criticality-change-btn",
    iconType: "arrowStart",
    iconSide: "left",
    flush: "right",
    onClick: () => toggleModal(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, criticality.status === 'update' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticality.changeButton",
    defaultMessage: "Change",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticality.createButton",
    defaultMessage: "Assign",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 19
    }
  })))), visible ? /*#__PURE__*/_react.default.createElement(AssetCriticalityModal, {
    onSave: onSave,
    initialCriticalityLevel: (_criticality$query$da2 = criticality.query.data) === null || _criticality$query$da2 === void 0 ? void 0 : _criticality$query$da2.criticality_level,
    toggle: toggleModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }) : null);
};
const AssetCriticalitySelector = exports.AssetCriticalitySelector = /*#__PURE__*/_react.default.memo(AssetCriticalitySelectorComponent);
AssetCriticalitySelector.displayName = 'AssetCriticalitySelector';
const AssetCriticalityAccordionComponent = ({
  entity,
  onChange
}) => {
  var _privileges$data, _privileges$data2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const privileges = (0, _use_asset_criticality.useAssetCriticalityPrivileges)(entity.name);
  const criticality = (0, _use_asset_criticality.useAssetCriticalityData)({
    entity,
    enabled: !!((_privileges$data = privileges.data) !== null && _privileges$data !== void 0 && _privileges$data.has_read_permissions),
    onChange
  });
  if (privileges.isLoading || !((_privileges$data2 = privileges.data) !== null && _privileges$data2 !== void 0 && _privileges$data2.has_read_permissions)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    id: "asset-criticality-selector",
    buttonContent: /*#__PURE__*/_react.default.createElement(AssetCriticalityTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 24
      }
    }),
    buttonProps: {
      css: (0, _css.css)`
            color: ${euiTheme.colors.primary};
          `
    },
    "data-test-subj": "asset-criticality-selector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(AssetCriticalitySelector, {
    criticality: criticality,
    entity: entity,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }));
};
const AssetCriticalityTitle = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticality.accordionTooltip",
    defaultMessage: "You can now categorize entities based on your organization's sensitivity and business risk. The classification tiers can be used to prioritize alert triage and investigation tasks. If the entity risk engine is enabled, the asset classification tier will dynamically impact the entity risk.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 185,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "xs",
  alignItems: "center",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 194,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 195,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 196,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement("h3", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 197,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.entityAnalytics.assetCriticality.accordionTitle",
  defaultMessage: "Asset Criticality",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 198,
    columnNumber: 13
  }
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 205,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "info",
  color: "subdued",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 206,
    columnNumber: 9
  }
}))));
exports.AssetCriticalityTitle = AssetCriticalityTitle;
const AssetCriticalityModal = ({
  initialCriticalityLevel,
  toggle,
  onSave
}) => {
  const basicSelectId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'basicSelect'
  });
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [value, setNewValue] = (0, _react.useState)(initialCriticalityLevel !== null && initialCriticalityLevel !== void 0 ? initialCriticalityLevel : 'unassigned');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: () => toggle(false),
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    "data-test-subj": "asset-criticality-modal-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 9
    }
  }, _translations.PICK_ASSET_CRITICALITY)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    id: basicSelectId,
    options: assetCriticalityOptions,
    valueOfSelected: value,
    onChange: setNewValue,
    "aria-label": _translations.PICK_ASSET_CRITICALITY,
    "data-test-subj": "asset-criticality-modal-select",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => toggle(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticality.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => onSave(value),
    fill: true,
    "data-test-subj": "asset-criticality-modal-save-btn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticality.saveButton",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 11
    }
  }))));
};
const option = level => ({
  value: level,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_asset_criticality_badge.AssetCriticalityBadge, {
    criticalityLevel: level,
    css: {
      lineHeight: 'inherit'
    },
    dataTestSubj: "asset-criticality-modal-select-option",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 5
    }
  }),
  inputDisplay: /*#__PURE__*/_react.default.createElement(_asset_criticality_badge.AssetCriticalityBadge, {
    criticalityLevel: level,
    css: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 17
    }
  })
});
const assetCriticalityOptions = exports.assetCriticalityOptions = [option('unassigned'), option('low_impact'), option('medium_impact'), option('high_impact'), option('extreme_impact')];
const AssetCriticalityAccordion = exports.AssetCriticalityAccordion = /*#__PURE__*/_react.default.memo(AssetCriticalityAccordionComponent);
AssetCriticalityAccordion.displayName = 'AssetCriticalityAccordion';