"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValidThreat = void 0;
var _mitre_tactics_techniques = require("./mitre_tactics_techniques");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  tactic,
  technique,
  subtechnique
} = (0, _mitre_tactics_techniques.getMockThreatData)()[0];
const {
  tactics,
  ...mockTechnique
} = technique;
const {
  tactics: subtechniqueTactics,
  ...mockSubtechnique
} = subtechnique;
const getValidThreat = () => [{
  framework: 'MITRE ATT&CK',
  tactic,
  technique: [{
    ...mockTechnique,
    subtechnique: [mockSubtechnique]
  }]
}];
exports.getValidThreat = getValidThreat;