"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdditionalBulkActions = void 0;
var _react = require("react");
var _use_bulk_alert_tags_items = require("../../../common/components/toolbar/bulk_actions/use_bulk_alert_tags_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that returns a list of action items and their respective panels when necessary.
 * The result is passed to the `additionalBulkActions` property of the ResponseOps alerts table.
 * These will be displayed in the Alert summary page table.
 */
const useAdditionalBulkActions = ({
  refetch
}) => {
  const {
    alertTagsItems,
    alertTagsPanels
  } = (0, _use_bulk_alert_tags_items.useBulkAlertTagsItems)({
    refetch
  });
  return (0, _react.useMemo)(() => [{
    id: 0,
    items: alertTagsItems
  }, ...alertTagsPanels], [alertTagsItems, alertTagsPanels]);
};
exports.useAdditionalBulkActions = useAdditionalBulkActions;