"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEventFilterModal = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEventFilterModal = () => {
  const [isAddEventFilterModalOpen, setIsAddEventFilterModalOpen] = (0, _react.useState)(false);
  const onAddEventFilterClick = (0, _react.useCallback)(() => {
    setIsAddEventFilterModalOpen(true);
  }, []);
  const closeAddEventFilterModal = (0, _react.useCallback)(() => {
    setIsAddEventFilterModalOpen(false);
  }, []);
  return {
    closeAddEventFilterModal,
    isAddEventFilterModalOpen,
    onAddEventFilterClick
  };
};
exports.useEventFilterModal = useEventFilterModal;