"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUsersBadge = exports.getSeverityComponent = exports.getRulesBadge = exports.getHostsBadge = exports.defaultGroupStatsRenderer = exports.Severity = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _alerts_grouping = require("../alerts_grouping");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_table/grouping_settings/default_group_stats_renderers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getUsersBadge = bucket => {
  var _bucket$usersCountAgg, _bucket$usersCountAgg2;
  return {
    title: i18n.STATS_GROUP_USERS,
    badge: {
      value: (_bucket$usersCountAgg = (_bucket$usersCountAgg2 = bucket.usersCountAggregation) === null || _bucket$usersCountAgg2 === void 0 ? void 0 : _bucket$usersCountAgg2.value) !== null && _bucket$usersCountAgg !== void 0 ? _bucket$usersCountAgg : 0
    }
  };
};
exports.getUsersBadge = getUsersBadge;
const getHostsBadge = bucket => {
  var _bucket$hostsCountAgg, _bucket$hostsCountAgg2;
  return {
    title: i18n.STATS_GROUP_HOSTS,
    badge: {
      value: (_bucket$hostsCountAgg = (_bucket$hostsCountAgg2 = bucket.hostsCountAggregation) === null || _bucket$hostsCountAgg2 === void 0 ? void 0 : _bucket$hostsCountAgg2.value) !== null && _bucket$hostsCountAgg !== void 0 ? _bucket$hostsCountAgg : 0
    }
  };
};
exports.getHostsBadge = getHostsBadge;
const getRulesBadge = bucket => {
  var _bucket$rulesCountAgg, _bucket$rulesCountAgg2;
  return {
    title: i18n.STATS_GROUP_RULES,
    badge: {
      value: (_bucket$rulesCountAgg = (_bucket$rulesCountAgg2 = bucket.rulesCountAggregation) === null || _bucket$rulesCountAgg2 === void 0 ? void 0 : _bucket$rulesCountAgg2.value) !== null && _bucket$rulesCountAgg !== void 0 ? _bucket$rulesCountAgg : 0
    }
  };
};
exports.getRulesBadge = getRulesBadge;
/**
 * Returns a colored icon and severity value (low, medium, high or critical) if only a single bucket is passed in.
 * If the value of the severity is null or incorrect, we return Unknown.
 * If there are multiple buckets, we return multiple icons.
 */
const Severity = exports.Severity = /*#__PURE__*/(0, _react.memo)(({
  severities
}) => {
  if (severities.length > 1) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
      className: "smallDot",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot",
      color: "#54b399",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement("span", {
      className: "smallDot",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot",
      color: "#d6bf57",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement("span", {
      className: "smallDot",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot",
      color: "#da8b45",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot",
      color: "#e7664c",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    })), i18n.STATS_GROUP_SEVERITY_MULTI);
  }
  const severity = severities[0].key;
  switch (severity) {
    case 'low':
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dot",
        color: "#54b399",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 11
        }
      }), i18n.STATS_GROUP_SEVERITY_LOW);
    case 'medium':
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dot",
        color: "#d6bf57",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 11
        }
      }), i18n.STATS_GROUP_SEVERITY_MEDIUM);
    case 'high':
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dot",
        color: "#da8b45",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 11
        }
      }), i18n.STATS_GROUP_SEVERITY_HIGH);
    case 'critical':
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dot",
        color: "#e7664c",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 11
        }
      }), i18n.STATS_GROUP_SEVERITY_CRITICAL);
    default:
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.STATS_GROUP_SEVERITY_UNKNOWN);
  }
});
Severity.displayName = 'Severity';

/**
 * Return a renderer for the severities aggregation.
 */
const getSeverityComponent = bucket => {
  var _bucket$severitiesSub;
  const severities = (_bucket$severitiesSub = bucket.severitiesSubAggregation) === null || _bucket$severitiesSub === void 0 ? void 0 : _bucket$severitiesSub.buckets;
  if (!severities || severities.length === 0) {
    return [];
  }
  return [{
    title: i18n.STATS_GROUP_SEVERITY,
    component: /*#__PURE__*/_react.default.createElement(Severity, {
      severities: severities,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 18
      }
    })
  }];
};

/**
 * Returns statistics to be used in the`extraAction` property of the EuiAccordion component used within the kbn-grouping package.
 * It handles custom renders for the following fields:
 * - kibana.alert.rule.name
 * - host.name
 * - user.name
 * - source.ip
 * And returns a default view for all the other fields.
 *
 * This go hand in hand with defaultGroupingOptions, defaultGroupTitleRenderers and defaultGroupStatsAggregations.
 */
exports.getSeverityComponent = getSeverityComponent;
const defaultGroupStatsRenderer = (selectedGroup, bucket) => {
  const severityComponent = getSeverityComponent(bucket);
  const defaultBadges = (0, _alerts_grouping.DEFAULT_GROUP_STATS_RENDERER)(selectedGroup, bucket);
  const usersBadge = getUsersBadge(bucket);
  const hostsBadge = getHostsBadge(bucket);
  const rulesBadge = getRulesBadge(bucket);
  switch (selectedGroup) {
    case 'kibana.alert.rule.name':
      return [...severityComponent, usersBadge, hostsBadge, ...defaultBadges];
    case 'host.name':
      return [...severityComponent, usersBadge, rulesBadge, ...defaultBadges];
    case 'user.name':
    case 'source.ip':
      return [...severityComponent, hostsBadge, rulesBadge, ...defaultBadges];
  }
  return [...severityComponent, rulesBadge, ...defaultBadges];
};
exports.defaultGroupStatsRenderer = defaultGroupStatsRenderer;