"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProgressBarRow = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_kpis/alerts_progress_bar_panel/alerts_progress_bar_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Renders a EuiProgress, used in the KPI chart for the alerts page as well as the AI for SOC alert summary page.
 */
const ProgressBarRow = ({
  item
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const color = (0, _react.useMemo)(() => euiTheme.themeName === 'EUI_THEME_BOREALIS' ? euiTheme.colors.vis.euiColorVis6 : euiTheme.colors.vis.euiColorVis9, [euiTheme]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    valueText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "default",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 11
      }
    }, item.percentageLabel)),
    max: 1,
    color: color,
    size: "s",
    value: item.percentage,
    label: item.key === 'Other' ? item.label : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      className: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 11
      }
    }, item.key),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  });
};
exports.ProgressBarRow = ProgressBarRow;
ProgressBarRow.displayName = 'ProgressBarRow';