"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupTitleRenderers = exports.RELATED_INTEGRATION_GROUP_RENDERER_TEST_ID = exports.IntegrationNameGroupContent = exports.INTEGRATION_GROUP_RENDERER_TEST_ID = exports.INTEGRATION_GROUP_RENDERER_INTEGRATION_NAME_TEST_ID = exports.INTEGRATION_GROUP_RENDERER_INTEGRATION_ICON_TEST_ID = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../constants");
var _integration_icon = require("../common/integration_icon");
var _table_section_context = require("./table_section_context");
var _grouping_settings = require("../../alerts_table/grouping_settings");
var _ecs_safety_helpers = require("../../../../../common/endpoint/models/ecs_safety_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/table/group_title_renderers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Returns renderers to be used in the `buttonContent` property of the EuiAccordion component used within the kbn-grouping package.
 * It handles custom renders for the following fields:
 * - relatedIntegration (a runTime field we're creating and using in the adhoc dataView)
 * - kibana.alert.rule.name
 * - host.name
 * - user.name
 * - source.ip
 * For all the other fields the default renderer managed within the kbn-grouping package will be used.
 *
 * These go hand in hand with groupingOptions, groupStatsRenderer and groupStatsAggregations.
 */
const groupTitleRenderers = (selectedGroup, bucket, nullGroupMessage) => {
  var _firstNonNullValue, _firstNonNullValue2, _bucket$description, _bucket$ruleTags;
  switch (selectedGroup) {
    case _constants.RELATED_INTEGRATION:
      return /*#__PURE__*/_react.default.createElement(IntegrationNameGroupContent, {
        title: bucket.key,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 14
        }
      });
    case 'kibana.alert.rule.name':
      return (0, _fp.isArray)(bucket.key) ? /*#__PURE__*/_react.default.createElement(_grouping_settings.RuleNameGroupContent, {
        ruleName: bucket.key[0],
        ruleDescription: (_firstNonNullValue = (0, _ecs_safety_helpers.firstNonNullValue)((_firstNonNullValue2 = (0, _ecs_safety_helpers.firstNonNullValue)((_bucket$description = bucket.description) === null || _bucket$description === void 0 ? void 0 : _bucket$description.buckets)) === null || _firstNonNullValue2 === void 0 ? void 0 : _firstNonNullValue2.key)) !== null && _firstNonNullValue !== void 0 ? _firstNonNullValue : '',
        tags: (_bucket$ruleTags = bucket.ruleTags) === null || _bucket$ruleTags === void 0 ? void 0 : _bucket$ruleTags.buckets,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 9
        }
      }) : undefined;
    case 'host.name':
      return /*#__PURE__*/_react.default.createElement(_grouping_settings.GroupWithIconContent, {
        title: bucket.key,
        icon: "storage",
        nullGroupMessage: nullGroupMessage,
        dataTestSubj: "host-name",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 9
        }
      });
    case 'user.name':
      return /*#__PURE__*/_react.default.createElement(_grouping_settings.GroupWithIconContent, {
        title: bucket.key,
        icon: "user",
        nullGroupMessage: nullGroupMessage,
        dataTestSubj: "user-name",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 9
        }
      });
    case 'source.ip':
      return /*#__PURE__*/_react.default.createElement(_grouping_settings.GroupWithIconContent, {
        title: bucket.key,
        icon: "globe",
        nullGroupMessage: nullGroupMessage,
        dataTestSubj: "source-ip",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 9
        }
      });
  }
};
exports.groupTitleRenderers = groupTitleRenderers;
const INTEGRATION_GROUP_RENDERER_TEST_ID = exports.INTEGRATION_GROUP_RENDERER_TEST_ID = 'integration-group-renderer';
const INTEGRATION_GROUP_RENDERER_INTEGRATION_NAME_TEST_ID = exports.INTEGRATION_GROUP_RENDERER_INTEGRATION_NAME_TEST_ID = 'integration-group-renderer-integration-name';
const INTEGRATION_GROUP_RENDERER_INTEGRATION_ICON_TEST_ID = exports.INTEGRATION_GROUP_RENDERER_INTEGRATION_ICON_TEST_ID = 'integration-group-renderer';
const RELATED_INTEGRATION_GROUP_RENDERER_TEST_ID = exports.RELATED_INTEGRATION_GROUP_RENDERER_TEST_ID = 'related-integration-group-renderer';

/**
 * Renders an icon and name of an integration.
 * This component needs to be used within the TableSectionContext which provides the installed packages.
 */
const IntegrationNameGroupContent = exports.IntegrationNameGroupContent = /*#__PURE__*/(0, _react.memo)(({
  title
}) => {
  const {
    packages
  } = (0, _table_section_context.useTableSectionContext)();
  const integrationName = Array.isArray(title) ? title[0] : title;
  const integration = packages.find(p => integrationName === p.name);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, integration ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": INTEGRATION_GROUP_RENDERER_TEST_ID,
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_icon.IntegrationIcon, {
    "data-test-subj": INTEGRATION_GROUP_RENDERER_INTEGRATION_ICON_TEST_ID,
    iconSize: "xl",
    integration: integration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": INTEGRATION_GROUP_RENDERER_INTEGRATION_NAME_TEST_ID,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 15
    }
  }, integration.title)))) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": RELATED_INTEGRATION_GROUP_RENDERER_TEST_ID,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, integrationName)));
});
IntegrationNameGroupContent.displayName = 'IntegrationNameGroup';