"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LAST_ACTIVITY_VALUE_TEST_ID = exports.LAST_ACTIVITY_LOADING_SKELETON_TEST_ID = exports.IntegrationCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _use_integration_last_alert_ingested = require("../../../hooks/alert_summary/use_integration_last_alert_ingested");
var _integration_icon = require("../common/integration_icon");
var _formatted_date = require("../../../../common/components/formatted_date");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/integrations/integration_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LAST_SYNCED = _i18n.i18n.translate('xpack.securitySolution.alertSummary.integrations.lastSyncedLabel', {
  defaultMessage: 'Last synced: '
});
const MIN_WIDTH = 200;
const REFRESH_INTERVAL = 30000; // 30 seconds

const LAST_ACTIVITY_LOADING_SKELETON_TEST_ID = exports.LAST_ACTIVITY_LOADING_SKELETON_TEST_ID = '-last-activity-loading-skeleton';
const LAST_ACTIVITY_VALUE_TEST_ID = exports.LAST_ACTIVITY_VALUE_TEST_ID = '-last-activity-value';
/**
 * Rendered on the alert summary page. The card displays the icon, name and last time the integration received alert data.
 */
const IntegrationCard = exports.IntegrationCard = /*#__PURE__*/(0, _react.memo)(({
  'data-test-subj': dataTestSubj,
  integration
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isLoading,
    lastAlertIngested,
    refetch
  } = (0, _use_integration_last_alert_ingested.useIntegrationLastAlertIngested)({
    integrationName: integration.name
  });

  // force a refresh every 30 seconds to update the last activity time
  (0, _react.useEffect)(() => {
    const interval = setInterval(() => refetch(), REFRESH_INTERVAL);
    return () => clearInterval(interval);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: (0, _react2.css)`
          min-width: ${MIN_WIDTH}px;
        `,
    "data-test-subj": dataTestSubj,
    hasBorder: true,
    hasShadow: false,
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_icon.IntegrationIcon, {
    "data-test-subj": dataTestSubj,
    iconSize: "xl",
    integration: integration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: (0, _react2.css)`
                    font-weight: ${euiTheme.font.weight.medium};
                  `,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 17
    }
  }, integration.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": `${dataTestSubj}${LAST_ACTIVITY_LOADING_SKELETON_TEST_ID}`,
    isLoading: isLoading,
    lines: 1,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": `${dataTestSubj}${LAST_ACTIVITY_VALUE_TEST_ID}`,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 19
    }
  }, LAST_SYNCED, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: lastAlertIngested
    /* we use key here to force re-render of the relative time */,
    key: Date.now(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 21
    }
  }))))))));
});
IntegrationCard.displayName = 'IntegrationCard';