"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractSingleKibanaFetchBodyBy = extractSingleKibanaFetchBodyBy;
exports.mockAvailableDataViews = mockAvailableDataViews;
exports.mockKibanaFetchResponse = mockKibanaFetchResponse;
exports.mockRelatedIntegrations = mockRelatedIntegrations;
exports.mockRuleUpgradeReviewData = mockRuleUpgradeReviewData;
exports.mockTimelines = mockTimelines;
exports.renderRuleUpgradeFlyout = renderRuleUpgradeFlyout;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@testing-library/react");
var _userEvent = _interopRequireDefault(require("@testing-library/user-event"));
var _invariant = require("../../../../../../../../common/utils/invariant");
var _constants = require("../../../../../../../../common/constants");
var _ = require("../../..");
var _detection_engine = require("../../../../../../../../common/api/detection_engine");
var _kibana = require("../../../../../../../common/lib/kibana");
var _rule_upgrade_test_providers = require("./rule_upgrade_test_providers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/pages/rule_management/__integration_tests__/rules_upgrade/test_utils/rule_upgrade_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/** **********************************************/
// Mocks necessary to render Rule Upgrade Flyout
jest.mock('../../../../../../../detections/components/user_info');
jest.mock('../../../../../../../detections/containers/detection_engine/lists/use_lists_config');
jest.mock('../../../../../components/rules_table/feature_tour/rules_feature_tour');
/** **********************************************/

/**
 * Stores KibanaServices.get().http.fetch() mocked responses.
 */
const mockedResponses = new Map();
async function renderRuleUpgradeFlyout() {
  // KibanaServices.get().http.fetch persists globally
  // it's important to clear the state for the later assertions
  _kibana.KibanaServices.get().http.fetch.mockClear();
  _kibana.KibanaServices.get().http.fetch.mockImplementation(requestedPath => mockedResponses.get(requestedPath));
  mockKibanaFetchResponse(_detection_engine.GET_PREBUILT_RULES_STATUS_URL, {
    stats: {
      num_prebuilt_rules_installed: 1,
      num_prebuilt_rules_to_install: 0,
      num_prebuilt_rules_to_upgrade: 1,
      num_prebuilt_rules_total_in_package: 1
    }
  });
  const renderResult = (0, _react2.render)(/*#__PURE__*/_react.default.createElement(_.RulesPage, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 31
    }
  }), {
    wrapper: _rule_upgrade_test_providers.RuleUpgradeTestProviders
  });
  await openRuleUpgradeFlyout();
  return renderResult;
}
function mockRuleUpgradeReviewData({
  ruleType,
  fieldName,
  fieldVersions,
  diffOutcome,
  conflict
}) {
  mockKibanaFetchResponse(_detection_engine.REVIEW_RULE_UPGRADE_URL, {
    stats: {
      num_rules_to_upgrade_total: 1,
      num_rules_with_conflicts: conflict === _detection_engine.ThreeWayDiffConflict.SOLVABLE || conflict === _detection_engine.ThreeWayDiffConflict.NON_SOLVABLE ? 1 : 0,
      num_rules_with_non_solvable_conflicts: conflict === _detection_engine.ThreeWayDiffConflict.NON_SOLVABLE ? 1 : 0,
      tags: []
    },
    rules: [{
      id: 'test-rule',
      rule_id: 'test-rule',
      current_rule: {
        rule_id: 'test-rule',
        type: ruleType,
        rule_source: {
          type: 'external',
          is_customized: true
        }
      },
      target_rule: {
        rule_id: 'test-rule',
        type: ruleType,
        threshold: {
          value: 30,
          field: ['fieldC']
        } // We use the `convertRuleToDiffable` util in the FieldUpgradeContext which needs relevant fields to convert
      },
      diff: {
        num_fields_with_updates: 2,
        // tested field + version field
        num_fields_with_conflicts: 1,
        num_fields_with_non_solvable_conflicts: 1,
        fields: {
          [fieldName]: {
            base_version: fieldVersions.base,
            current_version: fieldVersions.current,
            target_version: fieldVersions.target,
            merged_version: fieldVersions.merged,
            diff_outcome: diffOutcome,
            merge_outcome: _detection_engine.ThreeWayMergeOutcome.Current,
            has_base_version: Boolean(fieldVersions.base),
            has_update: diffOutcome === _detection_engine.ThreeWayDiffOutcome.CustomizedValueCanUpdate || diffOutcome === _detection_engine.ThreeWayDiffOutcome.StockValueCanUpdate || diffOutcome === _detection_engine.ThreeWayDiffOutcome.MissingBaseCanUpdate,
            conflict
          }
        }
      },
      revision: 1
    }]
  });
}

/**
 *
 * @param dataViews Mocked data views
 * @param stickyFields Fields added to all data views obtained via `dataViews.create()` or `dataViews.get()`
 */
function mockAvailableDataViews(dataViews, stickyFields) {
  _kibana.KibanaServices.get().data.dataViews.getIdsWithTitle.mockResolvedValue(dataViews.map(({
    id,
    title
  }) => ({
    id,
    title
  })));
  _kibana.KibanaServices.get().data.dataViews.create.mockImplementation(dataViewSpec => {
    var _dataViewSpec$fields;
    return createMockDataView({
      ...dataViewSpec,
      fields: {
        ...((_dataViewSpec$fields = dataViewSpec.fields) !== null && _dataViewSpec$fields !== void 0 ? _dataViewSpec$fields : {}),
        ...stickyFields
      }
    });
  });
  _kibana.KibanaServices.get().data.dataViews.get.mockImplementation(id => {
    var _dataView$fields;
    const dataView = dataViews.find(dv => dv.id === id);
    (0, _invariant.invariant)(dataView, `It's expected to have data view ${id} mock passed to mockAvailableDataViews() but it was not found`);
    return createMockDataView({
      ...dataView,
      fields: {
        ...((_dataView$fields = dataView.fields) !== null && _dataView$fields !== void 0 ? _dataView$fields : {}),
        ...stickyFields
      }
    });
  });
}
function mockRelatedIntegrations(relatedIntegrations) {
  mockKibanaFetchResponse(_detection_engine.GET_ALL_INTEGRATIONS_URL, {
    integrations: relatedIntegrations.map(ri => ({
      package_name: ri.package,
      package_title: ri.package,
      is_installed: true,
      is_enabled: true,
      latest_package_version: ri.version,
      installed_package_version: ri.version,
      integration_name: ri.integration,
      integration_title: ri.integration
    }))
  });
}
function mockTimelines(timelines) {
  mockKibanaFetchResponse(_constants.TIMELINES_URL, {
    timeline: timelines.map((t, index) => ({
      templateTimelineId: t.id,
      title: t.title,
      savedObjectId: `so-id-${index}`,
      version: '1'
    })),
    totalCount: timelines.length
  });
}

/**
 * Mocks KibanaServices.get().http.fetch() responses. Works in combination with renderRuleUpgradeFlyout.
 */
function mockKibanaFetchResponse(path, mockResponse) {
  mockedResponses.set(path, mockResponse);
}
async function openRuleUpgradeFlyout() {
  await _userEvent.default.click(await _react2.screen.findByTestId('ruleName'));
}
const createMockDataView = ({
  id,
  title,
  fields
}) => Promise.resolve({
  id,
  title,
  fields: Object.values(fields !== null && fields !== void 0 ? fields : {}).map(createFieldDefinition),
  getIndexPattern: jest.fn().mockReturnValue(title),
  toSpec: jest.fn().mockReturnValue({
    id,
    title,
    fields: Object.values(fields !== null && fields !== void 0 ? fields : {}).map(createFieldDefinition)
  })
});
function createFieldDefinition(fieldSpec) {
  return {
    ...fieldSpec,
    spec: {
      ...fieldSpec
    }
  };
}
function extractSingleKibanaFetchBodyBy({
  path,
  method
}) {
  const kibanaFetchMock = _kibana.KibanaServices.get().http.fetch;
  const ruleUpgradeRequests = kibanaFetchMock.mock.calls.filter(([_path, _options]) => _path === path && _options.method === method);
  expect(ruleUpgradeRequests).toHaveLength(1);
  try {
    return JSON.parse(ruleUpgradeRequests[0][1].body);
  } catch {
    throw new Error('Unable to parse Kibana fetch body');
  }
}