"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueListsFlyoutComponent = exports.ValueListsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _securitysolutionListApi = require("@kbn/securitysolution-list-api");
var _kibana = require("../../../../common/lib/kibana");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
var _table_helpers = require("./table_helpers");
var _form = require("./form");
var _reference_error_modal = require("../../../../common/components/reference_error_modal");
var _auto_download = require("../../../../common/components/auto_download/auto_download");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/value_lists_management_flyout/flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const referenceModalInitialState = {
  contentText: '',
  exceptionListReferences: [],
  isLoading: false,
  valueListId: ''
};
const ValueListsFlyoutComponent = ({
  onClose,
  showFlyout
}) => {
  var _lists$result$data, _lists$result2, _lists$result$total, _lists$result3;
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(5);
  const [cursor, setCursor] = (0, _securitysolutionListHooks.useCursor)({
    pageIndex,
    pageSize
  });
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    start: findLists,
    ...lists
  } = (0, _securitysolutionListHooks.useFindLists)();
  const {
    start: deleteList,
    result: deleteResult,
    error: deleteError
  } = (0, _securitysolutionListHooks.useDeleteList)();
  const [deletingListIds, setDeletingListIds] = (0, _react.useState)([]);
  const [exportingListIds, setExportingListIds] = (0, _react.useState)([]);
  const [exportDownload, setExportDownload] = (0, _react.useState)({});
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const [showReferenceErrorModal, setShowReferenceErrorModal] = (0, _react.useState)(false);
  const [referenceFlyoutState, setReferenceFlyoutState] = (0, _react.useState)(referenceModalInitialState);
  const fetchLists = (0, _react.useCallback)(() => {
    findLists({
      cursor,
      http,
      pageIndex: pageIndex + 1,
      pageSize,
      sortOrder: 'desc',
      sortField: 'created_at'
    });
  }, [cursor, http, findLists, pageIndex, pageSize]);
  const handleDelete = (0, _react.useCallback)(({
    deleteReferences,
    id
  }) => {
    setDeletingListIds([...deletingListIds, id]);
    deleteList({
      deleteReferences,
      http,
      id
    });
  }, [deleteList, deletingListIds, http]);
  const handleReferenceDelete = (0, _react.useCallback)(async () => {
    setShowReferenceErrorModal(false);
    deleteList({
      deleteReferences: true,
      http,
      id: referenceFlyoutState.valueListId
    });
    setReferenceFlyoutState(referenceModalInitialState);
    setDeletingListIds([]);
  }, [deleteList, http, referenceFlyoutState.valueListId]);
  (0, _react.useEffect)(() => {
    if (deleteResult != null) {
      setDeletingListIds(ids => [...ids.filter(id => id !== deleteResult.id)]);
      fetchLists();
    }
  }, [deleteResult, fetchLists]);
  (0, _react.useEffect)(() => {
    if (!(0, _fp.isEmpty)(deleteError)) {
      var _deleteError$body$mes, _deleteError$body, _deleteError$body$mes2, _deleteError$body$mes3, _deleteError$body$mes4, _deleteError$body2, _deleteError$body2$me, _deleteError$body2$me2;
      const references = // deleteError response unknown message.error.references
      // @ts-expect-error TS2571
      (_deleteError$body$mes = deleteError === null || deleteError === void 0 ? void 0 : (_deleteError$body = deleteError.body) === null || _deleteError$body === void 0 ? void 0 : (_deleteError$body$mes2 = _deleteError$body.message) === null || _deleteError$body$mes2 === void 0 ? void 0 : (_deleteError$body$mes3 = _deleteError$body$mes2.error) === null || _deleteError$body$mes3 === void 0 ? void 0 : (_deleteError$body$mes4 = _deleteError$body$mes3.references) === null || _deleteError$body$mes4 === void 0 ? void 0 : _deleteError$body$mes4.map(
      // response not typed
      // @ts-expect-error TS7006
      ref => ref === null || ref === void 0 ? void 0 : ref.exception_list.name)) !== null && _deleteError$body$mes !== void 0 ? _deleteError$body$mes : [];
      const uniqueExceptionListReferences = Array.from(new Set(references));
      setShowReferenceErrorModal(true);
      setReferenceFlyoutState({
        contentText: i18n.referenceErrorMessage(uniqueExceptionListReferences.length),
        exceptionListReferences: uniqueExceptionListReferences,
        isLoading: false,
        // deleteError response unknown
        // @ts-expect-error TS2571
        valueListId: deleteError === null || deleteError === void 0 ? void 0 : (_deleteError$body2 = deleteError.body) === null || _deleteError$body2 === void 0 ? void 0 : (_deleteError$body2$me = _deleteError$body2.message) === null || _deleteError$body2$me === void 0 ? void 0 : (_deleteError$body2$me2 = _deleteError$body2$me.error) === null || _deleteError$body2$me2 === void 0 ? void 0 : _deleteError$body2$me2.value_list_id
      });
    }
  }, [deleteError]);
  const handleExport = (0, _react.useCallback)(async ({
    id
  }) => {
    try {
      setExportingListIds(ids => [...ids, id]);
      const blob = await (0, _securitysolutionListApi.exportList)({
        http,
        listId: id,
        signal: new AbortController().signal
      });
      setExportDownload({
        name: id,
        blob
      });
    } catch (error) {
      addError(error, {
        title: i18n.EXPORT_ERROR
      });
    } finally {
      setExportingListIds(ids => [...ids.filter(_id => _id !== id)]);
    }
  }, [addError, http]);
  const handleTableChange = (0, _react.useCallback)(({
    page: {
      index,
      size
    }
  }) => {
    setPageIndex(index);
    setPageSize(size);
  }, [setPageIndex, setPageSize]);
  const handleUploadError = (0, _react.useCallback)(error => {
    if (error.name !== 'AbortError') {
      addError(error, {
        title: i18n.UPLOAD_ERROR
      });
    }
  }, [addError]);
  const handleUploadSuccess = (0, _react.useCallback)(response => {
    addSuccess({
      text: i18n.uploadSuccessMessage(response.name),
      title: i18n.UPLOAD_SUCCESS_TITLE
    });
    fetchLists();
    setPageIndex(0);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [addSuccess]);
  (0, _react.useEffect)(() => {
    if (showFlyout) {
      fetchLists();
    }
  }, [showFlyout, fetchLists]);
  (0, _react.useEffect)(() => {
    var _lists$result;
    if (!lists.loading && (_lists$result = lists.result) !== null && _lists$result !== void 0 && _lists$result.cursor) {
      setCursor(lists.result.cursor);
    }
  }, [lists.loading, lists.result, setCursor]);
  const handleCloseReferenceErrorModal = (0, _react.useCallback)(() => {
    setDeletingListIds([]);
    setShowReferenceErrorModal(false);
    setReferenceFlyoutState({
      contentText: '',
      exceptionListReferences: [],
      isLoading: false,
      valueListId: ''
    });
  }, []);
  const valueListsFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'valueListsFlyoutTitle'
  });
  if (!showFlyout) {
    return null;
  }
  const tableItems = ((_lists$result$data = (_lists$result2 = lists.result) === null || _lists$result2 === void 0 ? void 0 : _lists$result2.data) !== null && _lists$result$data !== void 0 ? _lists$result$data : []).map(item => ({
    ...item,
    isDeleting: deletingListIds.includes(item.id),
    isExporting: exportingListIds.includes(item.id)
  }));
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount: (_lists$result$total = (_lists$result3 = lists.result) === null || _lists$result3 === void 0 ? void 0 : _lists$result3.total) !== null && _lists$result$total !== void 0 ? _lists$result$total : 0,
    showPerPageOptions: false
  };
  const columns = (0, _table_helpers.buildColumns)(handleExport, handleDelete);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    maxWidth: 800,
    "aria-labelledby": valueListsFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: valueListsFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, i18n.VALUE_LISTS_FLYOUT_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_form.ValueListsForm, {
    onSuccess: handleUploadSuccess,
    onError: handleUploadError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 13
    }
  }, i18n.TABLE_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "value-lists-table",
    columns: columns,
    items: tableItems,
    loading: lists.loading,
    onChange: handleTableChange,
    pagination: pagination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "value-lists-flyout-close-action",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  }, i18n.CLOSE_BUTTON))), /*#__PURE__*/_react.default.createElement(_reference_error_modal.ReferenceErrorModal, {
    cancelText: i18n.REFERENCE_MODAL_CANCEL_BUTTON,
    confirmText: i18n.REFERENCE_MODAL_CONFIRM_BUTTON,
    contentText: referenceFlyoutState.contentText,
    onCancel: handleCloseReferenceErrorModal,
    onClose: handleCloseReferenceErrorModal,
    onConfirm: handleReferenceDelete,
    references: referenceFlyoutState.exceptionListReferences,
    showModal: showReferenceErrorModal,
    titleText: i18n.REFERENCE_MODAL_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_auto_download.AutoDownload, {
    blob: exportDownload.blob,
    name: exportDownload.name,
    onDownload: () => setExportDownload({}),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 7
    }
  }));
};
exports.ValueListsFlyoutComponent = ValueListsFlyoutComponent;
ValueListsFlyoutComponent.displayName = 'ValueListsFlyoutComponent';
const ValueListsFlyout = exports.ValueListsFlyout = /*#__PURE__*/_react.default.memo(ValueListsFlyoutComponent);
ValueListsFlyout.displayName = 'ValueListsFlyout';