"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpgradePrebuiltRulesTableColumns = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../../common/lib/telemetry/events/rule_upgrade/types");
var _detection_engine = require("../../../../../../common/api/detection_engine");
var _rules_table_empty_column_name = require("../rules_table_empty_column_name");
var _constants = require("../../../../../../common/constants");
var _popover_items = require("../../../../../common/components/popover_items");
var _kibana = require("../../../../../common/lib/kibana");
var _privileges = require("../../../../../common/utils/privileges");
var _integrations_popover = require("../../../../common/components/related_integrations/integrations_popover");
var _severity_badge = require("../../../../../common/components/severity_badge");
var _user_info = require("../../../../../detections/components/user_info");
var i18n = _interopRequireWildcard(require("../../../../common/translations"));
var _helpers = require("../helpers");
var _upgrade_prebuilt_rules_table_context = require("./upgrade_prebuilt_rules_table_context");
var _use_prebuilt_rules_customization_status = require("../../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_customization_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/use_upgrade_prebuilt_rules_table_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleName = ({
  name,
  ruleId
}) => {
  const {
    actions: {
      openRulePreview
    }
  } = (0, _upgrade_prebuilt_rules_table_context.useUpgradePrebuiltRulesTableContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      openRulePreview(ruleId);
    },
    "data-test-subj": "ruleName",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, name);
};
const RULE_NAME_COLUMN = {
  field: 'current_rule.name',
  name: i18n.COLUMN_RULE,
  render: (value, ruleUpgradeState) => /*#__PURE__*/_react.default.createElement(RuleName, {
    name: value,
    ruleId: ruleUpgradeState.rule_id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }),
  sortable: true,
  truncateText: true,
  width: '60%',
  align: 'left'
};
const TAGS_COLUMN = {
  field: 'current_rule.tags',
  name: /*#__PURE__*/_react.default.createElement(_rules_table_empty_column_name.RulesTableEmptyColumnName, {
    name: i18n.COLUMN_TAGS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }),
  align: 'center',
  render: tags => {
    if (tags == null || tags.length === 0) {
      return null;
    }
    const renderItem = (tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      key: `${tag}-${i}`,
      "data-test-subj": "tag",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    }, tag);
    return /*#__PURE__*/_react.default.createElement(_popover_items.PopoverItems, {
      items: tags,
      popoverTitle: i18n.COLUMN_TAGS,
      popoverButtonTitle: tags.length.toString(),
      popoverButtonIcon: "tag",
      dataTestPrefix: "tags",
      renderItem: renderItem,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    });
  },
  width: '65px',
  truncateText: true
};
const INTEGRATIONS_COLUMN = {
  field: 'current_rule.related_integrations',
  name: /*#__PURE__*/_react.default.createElement(_rules_table_empty_column_name.RulesTableEmptyColumnName, {
    name: i18n.COLUMN_INTEGRATIONS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }),
  align: 'center',
  render: integrations => {
    if (integrations == null || integrations.length === 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_integrations_popover.IntegrationsPopover, {
      relatedIntegrations: integrations,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 12
      }
    });
  },
  width: '70px',
  truncateText: true
};
const MODIFIED_COLUMN = {
  field: 'current_rule.rule_source',
  name: /*#__PURE__*/_react.default.createElement(_rules_table_empty_column_name.RulesTableEmptyColumnName, {
    name: i18n.COLUMN_MODIFIED,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }),
  align: 'center',
  render: ruleSource => {
    if (ruleSource == null || ruleSource.type === 'internal' || ruleSource.type === 'external' && ruleSource.is_customized === false) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.MODIFIED_TOOLTIP,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      "data-test-subj": "upgradeRulesTableModifiedColumnBadge",
      "aria-label": i18n.MODIFIED_LABEL,
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 9
      }
    }, i18n.MODIFIED_LABEL));
  },
  width: '90px',
  truncateText: true
};
const CONFLICT_COLUMN = {
  field: 'conflict',
  name: /*#__PURE__*/_react.default.createElement(_rules_table_empty_column_name.RulesTableEmptyColumnName, {
    name: i18n.COLUMN_CONFLICT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }),
  align: 'center',
  render: conflict => {
    switch (conflict) {
      case _detection_engine.ThreeWayDiffConflict.SOLVABLE:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: i18n.SOLVABLE_CONFLICT_TOOLTIP,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 155,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "warning",
          "data-test-subj": "upgradeRulesTableSolvableConflictColumnBadge",
          "aria-label": i18n.SOLVABLE_CONFLICT_LABEL,
          tabIndex: 0,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 156,
            columnNumber: 13
          }
        }, i18n.SOLVABLE_CONFLICT_LABEL));
      case _detection_engine.ThreeWayDiffConflict.NON_SOLVABLE:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: i18n.NON_SOLVABLE_CONFLICT_TOOLTIP,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 169,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "danger",
          "data-test-subj": "upgradeRulesTableUnsolvableConflictColumnBadge",
          "aria-label": i18n.NON_SOLVABLE_CONFLICT_LABEL,
          tabIndex: 0,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 170,
            columnNumber: 13
          }
        }, i18n.NON_SOLVABLE_CONFLICT_LABEL));
    }
  },
  width: '170px',
  truncateText: true
};
const createUpgradeButtonColumn = (upgradeRules, openRulePreview, loadingRules, isDisabled, isPrebuiltRulesCustomizationEnabled, telemetry) => ({
  field: 'rule_id',
  name: /*#__PURE__*/_react.default.createElement(_rules_table_empty_column_name.RulesTableEmptyColumnName, {
    name: i18n.UPDATE_RULE_BUTTON,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }),
  render: (ruleId, record) => {
    const isRuleUpgrading = loadingRules.includes(ruleId);
    const isDisabledByConflicts = isPrebuiltRulesCustomizationEnabled && record.hasUnresolvedConflicts;
    const isUpgradeButtonDisabled = isRuleUpgrading || isDisabled;
    const spinner = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s",
      "data-test-subj": `upgradeSinglePrebuiltRuleButton-loadingSpinner-${ruleId}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 7
      }
    });
    if (isDisabledByConflicts) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: i18n.UPDATE_RULE_BUTTON_TOOLTIP_CONFLICTS,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        color: "warning",
        size: "s",
        disabled: isUpgradeButtonDisabled,
        onClick: () => openRulePreview(ruleId),
        "data-test-subj": `reviewSinglePrebuiltRuleButton-${ruleId}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 11
        }
      }, isRuleUpgrading ? spinner : i18n.REVIEW_RULE_BUTTON));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      disabled: isUpgradeButtonDisabled,
      onClick: () => {
        telemetry.reportEvent(_types.RuleUpgradeEventTypes.RuleUpgradeSingleButtonClick, {
          hasBaseVersion: record.has_base_version === true
        });
        upgradeRules([ruleId]);
      },
      "data-test-subj": `upgradeSinglePrebuiltRuleButton-${ruleId}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 7
      }
    }, isRuleUpgrading ? spinner : i18n.UPDATE_RULE_BUTTON);
  },
  width: '10%',
  align: 'center'
});
const useUpgradePrebuiltRulesTableColumns = () => {
  const [{
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const hasCRUDPermissions = (0, _privileges.hasUserCRUDPermission)(canUserCRUD);
  const [showRelatedIntegrations] = (0, _kibana.useUiSetting$)(_constants.SHOW_RELATED_INTEGRATIONS_SETTING);
  const {
    state: {
      loadingRules,
      isRefetching,
      isUpgradingSecurityPackages
    },
    actions: {
      upgradeRules,
      openRulePreview
    }
  } = (0, _upgrade_prebuilt_rules_table_context.useUpgradePrebuiltRulesTableContext)();
  const isDisabled = isRefetching || isUpgradingSecurityPackages;
  const {
    isRulesCustomizationEnabled
  } = (0, _use_prebuilt_rules_customization_status.usePrebuiltRulesCustomizationStatus)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  return (0, _react.useMemo)(() => [RULE_NAME_COLUMN, MODIFIED_COLUMN, ...(isRulesCustomizationEnabled ? [CONFLICT_COLUMN] : []), ...(showRelatedIntegrations ? [INTEGRATIONS_COLUMN] : []), TAGS_COLUMN, {
    field: 'current_rule.risk_score',
    name: i18n.COLUMN_RISK_SCORE,
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "riskScore",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 11
      }
    }, value),
    sortable: true,
    truncateText: true,
    width: '85px'
  }, {
    field: 'current_rule.severity',
    name: i18n.COLUMN_SEVERITY,
    render: value => /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 46
      }
    }),
    sortable: ({
      current_rule: {
        severity
      }
    }) => (0, _helpers.getNormalizedSeverity)(severity),
    truncateText: true,
    width: '10%'
  }, ...(hasCRUDPermissions ? [createUpgradeButtonColumn(upgradeRules, openRulePreview, loadingRules, isDisabled, isRulesCustomizationEnabled, telemetry)] : [])], [showRelatedIntegrations, hasCRUDPermissions, upgradeRules, openRulePreview, loadingRules, isDisabled, isRulesCustomizationEnabled, telemetry]);
};
exports.useUpgradePrebuiltRulesTableColumns = useUpgradePrebuiltRulesTableColumns;