"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrebuiltRulesUpgradeState = usePrebuiltRulesUpgradeState;
var _react = require("react");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var _use_prebuilt_rules_customization_status = require("../../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_customization_status");
var _prebuilt_rule_upgrade = require("../../../../rule_management/model/prebuilt_rule_upgrade");
var _detection_engine = require("../../../../../../common/api/detection_engine");
var _utility_types = require("../../../../../../common/utility_types");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function usePrebuiltRulesUpgradeState(ruleUpgradeInfos) {
  const {
    isRulesCustomizationEnabled
  } = (0, _use_prebuilt_rules_customization_status.usePrebuiltRulesCustomizationStatus)();
  const [rulesResolvedValues, setRulesResolvedValues] = (0, _react.useState)({});
  const resetRuleResolvedValues = (0, _react.useCallback)(ruleId => {
    setRulesResolvedValues(prevRulesResolvedConflicts => ({
      ...prevRulesResolvedConflicts,
      [ruleId]: {}
    }));
  }, [setRulesResolvedValues]);
  const concurrencyControl = (0, _react.useRef)({});
  const {
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const setRuleFieldResolvedValue = (0, _react.useCallback)((...[params]) => {
    setRulesResolvedValues(prevRulesResolvedConflicts => {
      var _prevRulesResolvedCon;
      return {
        ...prevRulesResolvedConflicts,
        [params.ruleId]: {
          ...((_prevRulesResolvedCon = prevRulesResolvedConflicts[params.ruleId]) !== null && _prevRulesResolvedCon !== void 0 ? _prevRulesResolvedCon : {}),
          [params.fieldName]: params.resolvedValue
        }
      };
    });
  }, []);

  // Implements concurrency control.
  // Rule may be edited or a new prebuilt rules package version gets released.
  // In any case current rule's `revision` or target rule's version
  // will have higher values.
  // Reset resolved conflicts in case of revision`s or version`s mismatch.
  (0, _react.useEffect)(() => {
    for (const {
      rule_id: ruleId,
      current_rule: {
        revision: nextRevision,
        name
      },
      target_rule: {
        version: nextVersion
      }
    } of ruleUpgradeInfos) {
      var _rulesResolvedValues$;
      const cc = concurrencyControl.current[ruleId];
      const hasNewerRevision = cc ? nextRevision > cc.revision : false;
      const hasNewerVersion = cc ? nextVersion > cc.version : false;
      const hasResolvedValues = Object.keys((_rulesResolvedValues$ = rulesResolvedValues[ruleId]) !== null && _rulesResolvedValues$ !== void 0 ? _rulesResolvedValues$ : {}).length > 0;
      if (hasNewerRevision && hasResolvedValues) {
        addWarning({
          title: i18n.RULE_NEW_REVISION_DETECTED_WARNING,
          text: i18n.RULE_NEW_REVISION_DETECTED_WARNING_DESCRIPTION(name)
        });
      }
      if (hasNewerVersion && hasResolvedValues) {
        addWarning({
          title: i18n.RULE_NEW_VERSION_DETECTED_WARNING,
          text: i18n.RULE_NEW_VERSION_DETECTED_WARNING_DESCRIPTION(name)
        });
      }
      if ((hasNewerRevision || hasNewerVersion) && hasResolvedValues) {
        resetRuleResolvedValues(ruleId);
      }
      concurrencyControl.current[ruleId] = {
        version: nextVersion,
        revision: nextRevision
      };
    }
  }, [ruleUpgradeInfos, concurrencyControl, rulesResolvedValues, setRulesResolvedValues, resetRuleResolvedValues, addWarning]);
  const rulesUpgradeState = (0, _react.useMemo)(() => {
    const state = {};
    for (const ruleUpgradeInfo of ruleUpgradeInfos) {
      var _rulesResolvedValues$2;
      const fieldsUpgradeState = calcFieldsState(ruleUpgradeInfo.diff.fields, (_rulesResolvedValues$2 = rulesResolvedValues[ruleUpgradeInfo.rule_id]) !== null && _rulesResolvedValues$2 !== void 0 ? _rulesResolvedValues$2 : {});
      const hasRuleTypeChange = Boolean(ruleUpgradeInfo.diff.fields.type);
      const hasFieldConflicts = Object.values(fieldsUpgradeState).some(({
        state: fieldState
      }) => fieldState === _prebuilt_rule_upgrade.FieldUpgradeStateEnum.SolvableConflict || fieldState === _prebuilt_rule_upgrade.FieldUpgradeStateEnum.NonSolvableConflict);
      const hasNonSolvableFieldConflicts = Object.values(fieldsUpgradeState).some(({
        state: fieldState
      }) => fieldState === _prebuilt_rule_upgrade.FieldUpgradeStateEnum.NonSolvableConflict);
      state[ruleUpgradeInfo.rule_id] = {
        ...ruleUpgradeInfo,
        conflict: getWorstConflictLevelAmongFields(ruleUpgradeInfo.diff.fields),
        fieldsUpgradeState,
        hasUnresolvedConflicts: isRulesCustomizationEnabled ? hasRuleTypeChange || hasFieldConflicts : false,
        hasNonSolvableUnresolvedConflicts: isRulesCustomizationEnabled ? hasRuleTypeChange || hasNonSolvableFieldConflicts : false
      };
    }
    return state;
  }, [ruleUpgradeInfos, rulesResolvedValues, isRulesCustomizationEnabled]);
  return {
    rulesUpgradeState,
    setRuleFieldResolvedValue
  };
}
const NON_UPGRADEABLE_DIFFABLE_FIELDS_SET = new Set(_detection_engine.NON_UPGRADEABLE_DIFFABLE_FIELDS);
function calcFieldsState(fieldsDiff, ruleResolvedConflicts) {
  const fieldsState = {};
  for (const fieldName of Object.keys(fieldsDiff)) {
    if (NON_UPGRADEABLE_DIFFABLE_FIELDS_SET.has(fieldName)) {
      // eslint-disable-next-line no-continue
      continue;
    }
    const fieldDiff = fieldsDiff[fieldName];
    switch (fieldDiff.conflict) {
      case _detection_engine.ThreeWayDiffConflict.NONE:
        if (fieldDiff.has_update) {
          fieldsState[fieldName] = {
            state: _prebuilt_rule_upgrade.FieldUpgradeStateEnum.NoConflict
          };
        } else {
          fieldsState[fieldName] = {
            state: fieldDiff.diff_outcome === _detection_engine.ThreeWayDiffOutcome.CustomizedValueSameUpdate ? _prebuilt_rule_upgrade.FieldUpgradeStateEnum.SameUpdate : _prebuilt_rule_upgrade.FieldUpgradeStateEnum.NoUpdate
          };
        }
        break;
      case _detection_engine.ThreeWayDiffConflict.SOLVABLE:
        fieldsState[fieldName] = {
          state: _prebuilt_rule_upgrade.FieldUpgradeStateEnum.SolvableConflict
        };
        break;
      case _detection_engine.ThreeWayDiffConflict.NON_SOLVABLE:
        fieldsState[fieldName] = {
          state: _prebuilt_rule_upgrade.FieldUpgradeStateEnum.NonSolvableConflict
        };
        break;
      default:
        (0, _utility_types.assertUnreachable)(fieldDiff.conflict);
    }
  }
  for (const [fieldName, resolvedValue] of Object.entries(ruleResolvedConflicts)) {
    fieldsState[fieldName] = {
      state: _prebuilt_rule_upgrade.FieldUpgradeStateEnum.Accepted,
      resolvedValue
    };
  }
  return fieldsState;
}
function getWorstConflictLevelAmongFields(fieldsDiff) {
  let mostSevereFieldConflict = _detection_engine.ThreeWayDiffConflict.NONE;
  for (const {
    conflict
  } of Object.values(fieldsDiff)) {
    if (conflict === _detection_engine.ThreeWayDiffConflict.NON_SOLVABLE) {
      // return early as there is no higher severity
      return _detection_engine.ThreeWayDiffConflict.NON_SOLVABLE;
    }
    if (conflict === _detection_engine.ThreeWayDiffConflict.SOLVABLE) {
      mostSevereFieldConflict = _detection_engine.ThreeWayDiffConflict.SOLVABLE;
    }
  }
  return mostSevereFieldConflict;
}