"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncRulesTableSavedState = useSyncRulesTableSavedState;
var _react = require("react");
var _helpers = require("../../../../../common/utils/global_query_string/helpers");
var _kibana = require("../../../../../common/lib/kibana");
var _use_url_state = require("../../../../../common/hooks/use_url_state");
var _constants = require("../constants");
var _rules_table_context = require("./rules_table_context");
var _rules_table_saved_state = require("./rules_table_saved_state");
var _rules_table_defaults = require("./rules_table_defaults");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSyncRulesTableSavedState() {
  const {
    state
  } = (0, _rules_table_context.useRulesTableContext)();
  const {
    services: {
      sessionStorage
    }
  } = (0, _kibana.useKibana)();
  const replaceUrlParams = (0, _helpers.useReplaceUrlParams)();
  (0, _react.useEffect)(() => {
    const urlStateToSave = {};
    const storageStateToSave = {};
    if (state.filterOptions.filter.length > 0) {
      urlStateToSave.searchTerm = state.filterOptions.filter;
      storageStateToSave.searchTerm = state.filterOptions.filter;
    }
    if (state.filterOptions.showElasticRules || state.filterOptions.showCustomRules) {
      const source = state.filterOptions.showCustomRules ? _rules_table_saved_state.RuleSource.Custom : _rules_table_saved_state.RuleSource.Prebuilt;
      urlStateToSave.source = source;
      storageStateToSave.source = source;
    }
    if (state.filterOptions.tags.length > 0) {
      urlStateToSave.tags = state.filterOptions.tags;
      storageStateToSave.tags = state.filterOptions.tags;
    }
    if (state.filterOptions.enabled !== undefined) {
      urlStateToSave.enabled = state.filterOptions.enabled;
      storageStateToSave.enabled = state.filterOptions.enabled;
    }
    if (state.sortingOptions.field !== _rules_table_defaults.DEFAULT_SORTING_OPTIONS.field) {
      urlStateToSave.field = state.sortingOptions.field;
      storageStateToSave.field = state.sortingOptions.field;
    }
    if (state.sortingOptions.order !== _rules_table_defaults.DEFAULT_SORTING_OPTIONS.order) {
      urlStateToSave.order = state.sortingOptions.order;
      storageStateToSave.order = state.sortingOptions.order;
    }
    if (state.pagination.page !== _rules_table_defaults.DEFAULT_PAGE) {
      urlStateToSave.page = state.pagination.page;
    }
    if (state.pagination.perPage !== _rules_table_defaults.DEFAULT_RULES_PER_PAGE) {
      urlStateToSave.perPage = state.pagination.perPage;
      storageStateToSave.perPage = state.pagination.perPage;
    }
    if (state.filterOptions.ruleExecutionStatus !== undefined) {
      urlStateToSave.ruleExecutionStatus = state.filterOptions.ruleExecutionStatus;
      storageStateToSave.ruleExecutionStatus = state.filterOptions.ruleExecutionStatus;
    }
    const hasUrlStateToSave = Object.keys(urlStateToSave).length > 0;
    const hasStorageStateToSave = Object.keys(storageStateToSave).length > 0;
    if (!hasUrlStateToSave) {
      replaceUrlParams({
        [_use_url_state.URL_PARAM_KEY.rulesTable]: null
      });
    }
    if (!hasStorageStateToSave) {
      sessionStorage.remove(_constants.RULES_TABLE_STATE_STORAGE_KEY);
    }
    if (!hasUrlStateToSave && !hasStorageStateToSave) {
      return;
    }
    replaceUrlParams({
      [_use_url_state.URL_PARAM_KEY.rulesTable]: urlStateToSave
    });
    sessionStorage.set(_constants.RULES_TABLE_STATE_STORAGE_KEY, storageStateToSave);
  }, [replaceUrlParams, sessionStorage, state]);
}