"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.COMMON_FIELD_NAMES = void 0;
exports.isCommonFieldName = isCommonFieldName;
exports.isNonUpgradeableFieldName = isNonUpgradeableFieldName;
var _detection_engine = require("../../../../../common/api/detection_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMMON_FIELD_NAMES = exports.COMMON_FIELD_NAMES = _detection_engine.DiffableCommonFields.keyof().options;
function isCommonFieldName(fieldName) {
  return COMMON_FIELD_NAMES.includes(fieldName);
}
function isNonUpgradeableFieldName(fieldName) {
  return _detection_engine.NON_UPGRADEABLE_DIFFABLE_FIELDS.includes(fieldName);
}