"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePerformInstallSpecificRules = exports.usePerformInstallAllRules = void 0;
var _kibana = require("../../../../common/lib/kibana");
var _use_perform_all_rules_install_mutation = require("../../api/hooks/prebuilt_rules/use_perform_all_rules_install_mutation");
var _use_perform_specific_rules_install_mutation = require("../../api/hooks/prebuilt_rules/use_perform_specific_rules_install_mutation");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("../../../../common/components/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePerformInstallAllRules = () => {
  const toasts = (0, _kibana.useToasts)();
  return (0, _use_perform_all_rules_install_mutation.usePerformAllRulesInstallMutation)({
    onError: error => {
      handleErrorResponse(error, toasts);
    },
    onSuccess: result => {
      handleSuccessResponse(result, toasts);
    }
  });
};
exports.usePerformInstallAllRules = usePerformInstallAllRules;
const usePerformInstallSpecificRules = () => {
  const toasts = (0, _kibana.useToasts)();
  return (0, _use_perform_specific_rules_install_mutation.usePerformSpecificRulesInstallMutation)({
    onError: error => {
      handleErrorResponse(error, toasts);
    },
    onSuccess: result => {
      handleSuccessResponse(result, toasts);
    }
  });
};
exports.usePerformInstallSpecificRules = usePerformInstallSpecificRules;
function handleErrorResponse(error, toasts) {
  (0, _utils.showErrorToast)({
    title: i18n.RULE_INSTALLATION_FAILED,
    fullMessage: JSON.stringify(error, null, 2),
    toasts
  });
}
function handleSuccessResponse(result, toasts) {
  const successToastMessage = getSuccessToastMessage(result);
  if (successToastMessage) {
    toasts.addSuccess(successToastMessage);
  }
  if (result.summary.failed > 0) {
    (0, _utils.showErrorToast)({
      title: i18n.INSTALL_RULE_FAILED(result.summary.failed),
      fullMessage: JSON.stringify(result.errors, null, 2),
      toasts
    });
  }
}
function getSuccessToastMessage(result) {
  const toastMessages = [];
  const {
    summary: {
      succeeded,
      skipped
    }
  } = result;
  if (succeeded > 0) {
    toastMessages.push(i18n.INSTALL_RULE_SUCCESS(succeeded));
  }
  if (skipped > 0) {
    toastMessages.push(i18n.INSTALL_RULE_SKIPPED(skipped));
  }
  return toastMessages.join(' ');
}