"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDefaultIndexPattern = useDefaultIndexPattern;
var _kibana_react = require("../../../common/lib/kibana/kibana_react");
var _constants = require("../../../../common/constants");
var _use_prebuilt_rules_customization_status = require("../logic/prebuilt_rules/use_prebuilt_rules_customization_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Gets the default index pattern for cases when rule has neither index patterns or data view.
 * First checks the config value. If it's not present falls back to the hardcoded default value.
 */
function useDefaultIndexPattern() {
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const {
    isRulesCustomizationEnabled
  } = (0, _use_prebuilt_rules_customization_status.usePrebuiltRulesCustomizationStatus)();
  return isRulesCustomizationEnabled ? services.settings.client.get(_constants.DEFAULT_INDEX_KEY, _constants.DEFAULT_INDEX_PATTERN) : [];
}