"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleFieldEditFormWrapper = RuleFieldEditFormWrapper;
var _react = _interopRequireWildcard(require("react"));
var _extract_validation_messages = require("../../../../../../rule_creation/logic/extract_validation_messages");
var _use_form_with_warnings = require("../../../../../../../common/hooks/use_form_with_warnings");
var _shared_imports = require("../../../../../../../shared_imports");
var _field_upgrade_context = require("../../rule_upgrade/field_upgrade_context");
var _field_edit_form_context = require("../context/field_edit_form_context");
var _use_confirm_validation_errors_modal = require("../../../../../../../common/hooks/use_confirm_validation_errors_modal");
var _validation_warning_codes = require("../../../../../../rule_creation/constants/validation_warning_codes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/field_final_side/components/rule_field_edit_form_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * RuleFieldEditFormWrapper component manages form state and renders "Save" and "Cancel" buttons.
 *
 * @param {Object} props - Component props.
 * @param {React.ComponentType} props.component - Field component to be wrapped.
 * @param {FormSchema} props.ruleFieldFormSchema - Configuration schema for the field.
 * @param {Function} props.deserializer - Deserializer prepares initial form data. It converts field value from a DiffableRule format to a format used by the form.
 * @param {Function} props.serializer - Serializer prepares form data for submission. It converts form data back to a DiffableRule format.
 */
function RuleFieldEditFormWrapper({
  component: FieldComponent,
  ruleFieldFormSchema,
  deserializer,
  serializer
}) {
  const {
    registerForm
  } = (0, _field_edit_form_context.useFieldEditFormContext)();
  const {
    fieldName,
    finalDiffableRule,
    setReadOnlyMode,
    setRuleFieldResolvedValue
  } = (0, _field_upgrade_context.useFieldUpgradeContext)();
  const deserialize = (0, _react.useCallback)(defaultValue => deserializer ? deserializer(defaultValue, finalDiffableRule) : defaultValue, [deserializer, finalDiffableRule]);
  const {
    modal,
    confirmValidationErrors
  } = (0, _use_confirm_validation_errors_modal.useConfirmValidationErrorsModal)();
  const handleSubmit = (0, _react.useCallback)(async (formData, isValid, {
    warnings
  }) => {
    const warningMessages = (0, _extract_validation_messages.extractValidationMessages)(warnings, _validation_warning_codes.VALIDATION_WARNING_CODE_FIELD_NAME_MAP);
    if (!isValid || !(await confirmValidationErrors(warningMessages))) {
      return;
    }
    setRuleFieldResolvedValue({
      ruleId: finalDiffableRule.rule_id,
      fieldName: fieldName,
      resolvedValue: formData[fieldName]
    });
    setReadOnlyMode();
  }, [confirmValidationErrors, fieldName, finalDiffableRule.rule_id, setReadOnlyMode, setRuleFieldResolvedValue]);
  const {
    form
  } = (0, _use_form_with_warnings.useFormWithWarnings)({
    schema: ruleFieldFormSchema,
    defaultValue: getDefaultValue(fieldName, finalDiffableRule),
    deserializer: deserialize,
    serializer,
    onSubmit: handleSubmit,
    options: {
      warningValidationCodes: _validation_warning_codes.VALIDATION_WARNING_CODES,
      stripEmptyFields: false
    }
  });
  (0, _react.useEffect)(() => registerForm(form), [registerForm, form]);

  // form.isValid has `undefined` value until all fields are dirty.
  // Run the validation upfront to visualize form validity state.
  (0, _react.useEffect)(() => {
    form.validate();
  }, [form]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  }, modal, /*#__PURE__*/_react.default.createElement(FieldComponent, {
    finalDiffableRule: finalDiffableRule,
    setFieldValue: form.setFieldValue,
    resetForm: form.reset,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }));
}
function getDefaultValue(fieldName, finalDiffableRule) {
  return {
    [fieldName]: finalDiffableRule[fieldName]
  };
}