"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION_PICKER_ARIA_LABEL = exports.VERSION1_VS_VERSION2 = exports.TARGET_VERSION = exports.FINAL_VERSION = exports.CURRENT_VERSION = exports.BASE_VERSION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASE_VERSION = exports.BASE_VERSION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versions.baseVersionLabel', {
  defaultMessage: 'Original'
});
const CURRENT_VERSION = exports.CURRENT_VERSION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versions.currentVersionLabel', {
  defaultMessage: 'Current'
});
const TARGET_VERSION = exports.TARGET_VERSION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versions.targetVersionLabel', {
  defaultMessage: 'Elastic update'
});
const FINAL_VERSION = exports.FINAL_VERSION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versions.finalVersionLabel', {
  defaultMessage: 'Final'
});
const VERSION1_VS_VERSION2 = (version1, version2) => {
  return _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versionsPicker.version1VsVersion2', {
    defaultMessage: '{version1} vs {version2}',
    values: {
      version1,
      version2
    }
  });
};
exports.VERSION1_VS_VERSION2 = VERSION1_VS_VERSION2;
const VERSION_PICKER_ARIA_LABEL = exports.VERSION_PICKER_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versionsPicker.ariaLabel', {
  defaultMessage: 'Select versions to compare'
});