"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubfieldChangesForTimelineTemplate = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSubfieldChangesForTimelineTemplate = (oldFieldValue, newFieldValue) => {
  const changes = [];
  const oldTimelineId = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.timeline_id);
  const newTimelineId = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.timeline_id);
  if (oldTimelineId !== newTimelineId) {
    changes.push({
      subfieldName: 'timeline_id',
      oldSubfieldValue: oldTimelineId,
      newSubfieldValue: newTimelineId
    });
  }
  const oldTimelineTitle = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.timeline_title);
  const newTimelineTitle = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.timeline_title);
  if (oldTimelineTitle !== newTimelineTitle) {
    changes.push({
      subfieldName: 'timeline_title',
      oldSubfieldValue: oldTimelineTitle,
      newSubfieldValue: newTimelineTitle
    });
  }
  return changes;
};
exports.getSubfieldChangesForTimelineTemplate = getSubfieldChangesForTimelineTemplate;