"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubfieldChangesForThreatQuery = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSubfieldChangesForThreatQuery = (oldFieldValue, newFieldValue) => {
  const changes = [];
  const oldQuery = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.query);
  const newQuery = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.query);
  if (oldQuery !== newQuery) {
    changes.push({
      subfieldName: 'query',
      oldSubfieldValue: oldQuery,
      newSubfieldValue: newQuery
    });
  }
  const oldLanguage = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.language);
  const newLanguage = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.language);
  if (oldLanguage !== newLanguage) {
    changes.push({
      subfieldName: 'language',
      oldSubfieldValue: oldLanguage,
      newSubfieldValue: newLanguage
    });
  }
  const oldFilters = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.filters);
  const newFilters = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.filters);
  if (oldFilters !== newFilters) {
    changes.push({
      subfieldName: 'filters',
      oldSubfieldValue: oldFilters,
      newSubfieldValue: newFilters
    });
  }
  return changes;
};
exports.getSubfieldChangesForThreatQuery = getSubfieldChangesForThreatQuery;