"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleUpdateCallout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _use_prebuilt_rules_upgrade = require("../../hooks/use_prebuilt_rules_upgrade");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/rule_update_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleUpdateCalloutComponent = ({
  rule,
  message,
  actionButton,
  onUpgrade
}) => {
  const {
    upgradeReviewResponse,
    rulePreviewFlyout,
    openRulePreview
  } = (0, _use_prebuilt_rules_upgrade.usePrebuiltRulesUpgrade)({
    pagination: {
      page: 1,
      // we only want to fetch one result
      perPage: 1
    },
    filter: {
      rule_ids: [rule.id]
    },
    onUpgrade
  });
  const isRuleUpgradeable = (0, _react.useMemo)(() => upgradeReviewResponse !== undefined && upgradeReviewResponse.total > 0, [upgradeReviewResponse]);
  const updateCallToActionButton = (0, _react.useMemo)(() => {
    if (actionButton) {
      return actionButton;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => openRulePreview(rule.rule_id),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    }, i18n.HAS_RULE_UPDATE_CALLOUT_BUTTON);
  }, [actionButton, openRulePreview, rule.rule_id]);
  if (!isRuleUpgradeable) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.HAS_RULE_UPDATE_CALLOUT_TITLE,
    color: "primary",
    iconType: "gear",
    "data-test-subj": "single-prebuilt-rule-upgrade-callout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, message), updateCallToActionButton), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }), rulePreviewFlyout);
};
const RuleUpdateCallout = exports.RuleUpdateCallout = /*#__PURE__*/_react.default.memo(RuleUpdateCalloutComponent);