"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteBackfill = exports.DELETE_BACKFILL_MUTATION_KEY = void 0;
var _reactQuery = require("@kbn/react-query");
var _api = require("../api");
var _use_find_backfills_for_rules = require("./use_find_backfills_for_rules");
var _use_find_gaps_for_rule = require("./use_find_gaps_for_rule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DELETE_BACKFILL_MUTATION_KEY = exports.DELETE_BACKFILL_MUTATION_KEY = ['POST', ' DELETE_BACKFILL_MUTATION_KEY'];
const useDeleteBackfill = options => {
  const invalidateBackfillQuery = (0, _use_find_backfills_for_rules.useInvalidateFindBackfillQuery)();
  const invalidateFindGapsQuery = (0, _use_find_gaps_for_rule.useInvalidateFindGapsQuery)();
  return (0, _reactQuery.useMutation)(_api.deleteBackfill, {
    ...options,
    mutationKey: DELETE_BACKFILL_MUTATION_KEY,
    onSettled: (...args) => {
      invalidateBackfillQuery();
      invalidateFindGapsQuery();
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    }
  });
};
exports.useDeleteBackfill = useDeleteBackfill;