"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useValueWithSpaceWarning = void 0;
var _securitysolutionAutocomplete = require("@kbn/securitysolution-autocomplete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useValueWithSpaceWarning = ({
  value,
  tooltipIconText
}) => {
  const showSpaceWarningIcon = Array.isArray(value) ? value.find(_securitysolutionAutocomplete.paramContainsSpace) : (0, _securitysolutionAutocomplete.paramContainsSpace)(value);
  return {
    showSpaceWarningIcon: !!showSpaceWarningIcon,
    warningText: tooltipIconText || _securitysolutionAutocomplete.autoCompletei18n.FIELD_SPACE_WARNING
  };
};
exports.useValueWithSpaceWarning = useValueWithSpaceWarning;