"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNKNOWN_AVATAR_NAME = exports.COMMENT_MAX_LENGTH_ERROR = exports.COMMENTS_SHOW = exports.COMMENTS_HIDE = exports.ADD_COMMENT_PLACEHOLDER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UNKNOWN_AVATAR_NAME = exports.UNKNOWN_AVATAR_NAME = _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.itemComments.unknownAvatarName', {
  defaultMessage: 'Uknown'
});
const ADD_COMMENT_PLACEHOLDER = exports.ADD_COMMENT_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.itemComments.addCommentPlaceholder', {
  defaultMessage: 'Add a new comment...'
});
const COMMENTS_SHOW = comments => _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.itemComments.showCommentsLabel', {
  values: {
    comments
  },
  defaultMessage: 'Show ({comments}) {comments, plural, =1 {Comment} other {Comments}}'
});
exports.COMMENTS_SHOW = COMMENTS_SHOW;
const COMMENTS_HIDE = comments => _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.itemComments.hideCommentsLabel', {
  values: {
    comments
  },
  defaultMessage: 'Hide ({comments}) {comments, plural, =1 {Comment} other {Comments}}'
});
exports.COMMENTS_HIDE = COMMENTS_HIDE;
const COMMENT_MAX_LENGTH_ERROR = length => _i18n.i18n.translate('xpack.securitySolution.rule_exceptions.itemComments.maxLengthError', {
  values: {
    length
  },
  defaultMessage: 'The length of the comment is too long. The maximum length is {length} characters.'
});
exports.COMMENT_MAX_LENGTH_ERROR = COMMENT_MAX_LENGTH_ERROR;