"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsExpireTime = void 0;
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/flyout_components/expire_time/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SectionHeader = (0, _styledComponents.default)(_eui.EuiTitle)`
  ${() => (0, _styledComponents.css)`
    font-weight: ${({
  theme
}) => theme.eui.euiFontWeightSemiBold};
  `}
`;
const ExceptionItemExpireTime = ({
  expireTime,
  setExpireTime,
  setExpireError
}) => {
  const [dateTime, setDateTime] = (0, _react.useState)(expireTime);
  const [isInvalid, setIsInvalid] = (0, _react.useState)(false);
  const [errors, setErrors] = (0, _react.useState)([]);
  const handleChange = (0, _react.useCallback)(date => {
    setDateTime(date !== null && date !== void 0 ? date : undefined);
    setExpireTime(date !== null && date !== void 0 ? date : undefined);
    if (date !== null && date !== void 0 && date.isBefore()) {
      setIsInvalid(true);
      setErrors([i18n.EXCEPTION_EXPIRE_TIME_ERROR]);
      setExpireError(true);
    } else {
      setIsInvalid(false);
      setErrors([]);
      setExpireError(false);
    }
  }, [setDateTime, setExpireTime, setExpireError]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(SectionHeader, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, i18n.EXCEPTION_EXPIRE_TIME_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: errors,
    isInvalid: isInvalid,
    label: i18n.EXPIRE_TIME_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    showTimeSelect: true,
    selected: dateTime,
    isInvalid: isInvalid,
    onChange: handleChange,
    onClear: () => handleChange(null),
    minDate: (0, _moment.default)(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  })));
};
const ExceptionsExpireTime = exports.ExceptionsExpireTime = /*#__PURE__*/_react.default.memo(ExceptionItemExpireTime);
ExceptionsExpireTime.displayName = 'ExceptionsExpireTime';