"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditExceptionItems = void 0;
var _react = require("react");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_create_update_exception = require("../../logic/use_create_update_exception");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for editing exception items from flyout
 *
 */
const useEditExceptionItems = () => {
  const {
    addSuccess,
    addError,
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const [isAddingExceptions, updateExceptions] = (0, _use_create_update_exception.useCreateOrUpdateException)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const updateExceptionsRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const abortCtrl = new AbortController();
    const updateExceptionItem = async ({
      itemsToUpdate
    }) => {
      if (updateExceptions == null) return;
      try {
        setIsLoading(true);
        await updateExceptions(itemsToUpdate);
        addSuccess({
          title: i18n.EDIT_RULE_EXCEPTION_SUCCESS_TITLE,
          text: i18n.EDIT_RULE_EXCEPTION_SUCCESS_TEXT(itemsToUpdate.map(({
            name
          }) => name).join(', '), itemsToUpdate.length)
        });
        if (isSubscribed) {
          setIsLoading(false);
        }
      } catch (e) {
        if (isSubscribed) {
          setIsLoading(false);
          addError(e, {
            title: i18n.EDIT_RULE_EXCEPTION_ERROR_TITLE
          });
          throw new Error(e);
        }
      }
    };
    updateExceptionsRef.current = updateExceptionItem;
    return () => {
      isSubscribed = false;
      abortCtrl.abort();
    };
  }, [addSuccess, addError, addWarning, updateExceptions]);
  return [isLoading || isAddingExceptions, updateExceptionsRef.current];
};
exports.useEditExceptionItems = useEditExceptionItems;