"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareToCloseAlerts = exports.prepareNewItemsForSubmission = exports.isSubmitDisabled = exports.getSuccessToastTitle = exports.getSuccessToastText = void 0;
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _fp = require("lodash/fp");
var _utils = require("../flyout_components/utils");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_DEFAULT_OPTIONS = ['add_to_rule', 'add_to_rules', 'select_rules_to_add_to'];

/**
 * Determines whether add exception flyout submit button
 * should be disabled.
 * @param isSubmitting Is submition completed
 * @param isClosingAlerts Waiting on close alerts actions to complete
 * @param errorSubmitting Any submission errors
 * @param exceptionItemName Item name
 * @param exceptionItems Items to be created
 * @param itemConditionValidationErrorExists Item conditions are invalid
 * @param commentErrorExists Comment invalid or errors exist
 * @param expireErrorExists Expire time invalid or error exists
 * @param addExceptionToRadioSelection Radio selection value denoting whether to add item to lists or rules
 * @param selectedRulesToAddTo List of rules item/s should be added to
 * @param listType list type of the item being added
 * @param exceptionListsToAddTo User selected exception lists to add item to
 */
const isSubmitDisabled = ({
  isSubmitting,
  isClosingAlerts,
  errorSubmitting,
  exceptionItemName,
  exceptionItems,
  itemConditionValidationErrorExists,
  commentErrorExists,
  expireErrorExists,
  addExceptionToRadioSelection,
  selectedRulesToAddTo,
  listType,
  exceptionListsToAddTo
}) => {
  return isSubmitting || isClosingAlerts || errorSubmitting != null || exceptionItemName.trim() === '' || exceptionItems.every(item => item.entries.length === 0) || itemConditionValidationErrorExists || commentErrorExists || expireErrorExists || addExceptionToRadioSelection === 'add_to_lists' && (0, _fp.isEmpty)(exceptionListsToAddTo) || addExceptionToRadioSelection === 'select_rules_to_add_to' && (0, _fp.isEmpty)(selectedRulesToAddTo) && listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.RULE_DEFAULT;
};

/**
 * Helper method for determining if user has selected to add exception
 * items to specific rules or to exception lists. It also returns the
 * exception items enriched with various flyout values.
 * @param sharedListToAddTo Exception list passed into add exception item flyout component
 * @param addExceptionToRadioSelection Radio selection value denoting whether to add item to lists or rules
 * @param exceptionListsToAddTo User selected exception lists to add item to
 * @param exceptionItemName Item name
 * @param newComment User added comment
 * @param listType list type of the item being added
 * @param osTypesSelection For endpoint exceptions, OS selected
 * @param expireTime User defined item expire time
 * @param exceptionItems Items to be added
 */
exports.isSubmitDisabled = isSubmitDisabled;
const prepareNewItemsForSubmission = ({
  sharedListToAddTo,
  addExceptionToRadioSelection,
  exceptionListsToAddTo,
  exceptionItemName,
  newComment,
  listType,
  osTypesSelection,
  expireTime,
  exceptionItems
}) => {
  const addToRules = RULE_DEFAULT_OPTIONS.includes(addExceptionToRadioSelection);
  const addToLists = !!(sharedListToAddTo !== null && sharedListToAddTo !== void 0 && sharedListToAddTo.length) || addExceptionToRadioSelection === 'add_to_lists' && !(0, _fp.isEmpty)(exceptionListsToAddTo);
  const listsToAddTo = sharedListToAddTo !== null && sharedListToAddTo !== void 0 && sharedListToAddTo.length ? sharedListToAddTo : exceptionListsToAddTo;
  const items = (0, _utils.enrichNewExceptionItems)({
    itemName: exceptionItemName,
    commentToAdd: newComment,
    addToRules,
    addToSharedLists: addToLists,
    sharedLists: listsToAddTo,
    listType,
    selectedOs: osTypesSelection,
    expireTime,
    items: exceptionItems
  });
  return {
    listsToAddTo,
    addToLists,
    addToRules,
    items
  };
};

/**
 * Determine whether to close a single alert or bulk close
 * alerts. Depending on the selection, need to know alert id
 * and rule ids.
 * @param alertData Alert the item is being added to
 * @param closeSingleAlert User selected to close a single alert
 * @param addToRules User selected to add item to 'x' rules
 * @param rules Rules to determine which alerts to target when bulk closing
 * @param bulkCloseAlerts User selected to close all alerts matching new exception
 * @param selectedRulesToAddTo User selected rules to add item to
 */
exports.prepareNewItemsForSubmission = prepareNewItemsForSubmission;
const prepareToCloseAlerts = ({
  alertData,
  closeSingleAlert,
  addToRules,
  rules,
  bulkCloseAlerts,
  selectedRulesToAddTo
}) => {
  const alertIdToClose = closeSingleAlert && alertData ? alertData._id : undefined;
  const ruleStaticIds = addToRules ? selectedRulesToAddTo.map(({
    rule_id: ruleId
  }) => ruleId) : (rules !== null && rules !== void 0 ? rules : []).map(({
    rule_id: ruleId
  }) => ruleId);
  return {
    shouldCloseAlerts: !(0, _fp.isEmpty)(ruleStaticIds) && (bulkCloseAlerts || closeSingleAlert),
    alertIdToClose,
    ruleStaticIds
  };
};
exports.prepareToCloseAlerts = prepareToCloseAlerts;
const getSuccessToastTitle = listType => listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.ADD_ENDPOINT_EXCEPTION_SUCCESS : i18n.ADD_EXCEPTION_SUCCESS;
exports.getSuccessToastTitle = getSuccessToastTitle;
const getSuccessToastText = (listType, sharedListNames) => i18n.ADD_EXCEPTION_SUCCESS_DETAILS(listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? 'Endpoint' : 'Rule', sharedListNames.join(','));
exports.getSuccessToastText = getSuccessToastText;