"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePersistentMachineLearningState = usePersistentMachineLearningState;
var _react = require("react");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _utils = require("../../../../../common/detection_engine/utils");
var _shared_imports = require("../../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function usePersistentMachineLearningState({
  form,
  ruleTypePath,
  machineLearningJobIdPath,
  anomalyThresholdPath
}) {
  const lastMlState = (0, _react.useRef)();
  const [formData] = (0, _shared_imports.useFormData)({
    form
  });
  const {
    [ruleTypePath]: ruleType,
    [machineLearningJobIdPath]: machineLearningJobId,
    [anomalyThresholdPath]: anomalyThreshold
  } = formData;
  const previousRuleType = (0, _usePrevious.default)(ruleType);
  (0, _react.useEffect)(() => {
    if ((0, _utils.isMlRule)(ruleType) && !(0, _utils.isMlRule)(previousRuleType) && lastMlState.current) {
      form.updateFieldValues({
        [machineLearningJobIdPath]: lastMlState.current.machineLearningJobId,
        [anomalyThresholdPath]: lastMlState.current.anomalyThreshold
      });
      return;
    }
    if ((0, _utils.isMlRule)(ruleType)) {
      lastMlState.current = {
        machineLearningJobId,
        anomalyThreshold
      };
    }
  }, [form, ruleType, previousRuleType, machineLearningJobIdPath, anomalyThresholdPath, machineLearningJobId, anomalyThreshold]);
}