"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_SIGNALS_HELP_TEXT = exports.LESS_THAN_WARNING = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LESS_THAN_WARNING = maxNumber => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.maxAlertsFieldLessThanWarning', {
  values: {
    maxNumber
  },
  defaultMessage: 'Kibana only allows a maximum of {maxNumber} {maxNumber, plural, =1 {alert} other {alerts}} per rule run.'
});
exports.LESS_THAN_WARNING = LESS_THAN_WARNING;
const MAX_SIGNALS_HELP_TEXT = defaultNumber => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldMaxAlertsHelpText', {
  values: {
    defaultNumber
  },
  defaultMessage: 'The maximum number of alerts the rule will create each time it runs. Default is {defaultNumber}.'
});
exports.MAX_SIGNALS_HELP_TEXT = MAX_SIGNALS_HELP_TEXT;