"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsFieldSelectorField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionAutocomplete = require("@kbn/securitysolution-autocomplete");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/es_field_selector_field/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EsFieldSelectorField = ({
  dataTestSubj,
  field,
  idAria,
  indices,
  isDisabled,
  fieldType,
  placeholder
}) => {
  const fieldTypeFilter = (0, _react.useMemo)(() => [fieldType], [fieldType]);
  const handleFieldChange = (0, _react.useCallback)(([newField]) => {
    var _newField$name;
    field.setValue((_newField$name = newField === null || newField === void 0 ? void 0 : newField.name) !== null && _newField$name !== void 0 ? _newField$name : '');
  }, [field]);
  const selectedField = (0, _react.useMemo)(() => {
    var _indices$fields$find;
    return (_indices$fields$find = indices.fields.find(({
      name
    }) => field.value === name)) !== null && _indices$fields$find !== void 0 ? _indices$fields$find : {
      name: field.value,
      type: fieldType
    };
  }, [field.value, indices, fieldType]);
  const describedByIds = (0, _react.useMemo)(() => idAria ? [idAria] : undefined, [idAria]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": dataTestSubj,
    describedByIds: describedByIds,
    fullWidth: true,
    helpText: field.helpText,
    label: field.label,
    labelAppend: field.labelAppend,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.EsFieldSelector, {
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : '',
    indexPattern: indices,
    selectedField: selectedField,
    fieldTypeFilter: fieldTypeFilter,
    isLoading: false,
    isDisabled: isDisabled,
    isClearable: false,
    onChange: handleFieldChange,
    "data-test-subj": dataTestSubj,
    "aria-label": idAria,
    fieldInputWidth: 500,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }));
};
exports.EsFieldSelectorField = EsFieldSelectorField;