"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDescriptionItem = exports.buildListItems = exports.addFilterStateIfNotThere = exports.StepRuleDescriptionComponent = exports.StepRuleDescription = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
var _integrations_description = require("../../../common/components/related_integrations/integrations_description");
var _translations = require("../../../../timelines/components/timeline/translations");
var _kibana = require("../../../../common/lib/kibana");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _build_ml_jobs_description = require("./build_ml_jobs_description");
var _actions_description = require("./actions_description");
var _throttle_description = require("./throttle_description");
var _helpers2 = require("../../pages/rule_creation/helpers");
var _use_license = require("../../../../common/hooks/use_license");
var _utils = require("../../../../../common/detection_engine/utils");
var _alert_suppression_edit = require("../../../rule_creation/components/alert_suppression_edit");
var _threshold_alert_suppression_edit = require("../../../rule_creation/components/threshold_alert_suppression_edit");
var _translations3 = require("../../../rule_creation/components/threshold_edit/translations");
var _translations4 = require("../../../rule_creation/components/new_terms_fields_edit/translations");
var _translations5 = require("../../../rule_creation/components/history_window_start_edit/translations");
var _translations6 = require("../../../rule_creation/components/machine_learning_job_id_edit/translations");
var _translations7 = require("../../../rule_creation/components/anomaly_threshold_edit/translations");
var _translations8 = require("../../../rule_creation/components/threat_match_mapping_edit/translations");
var _translations9 = require("../../../rule_creation/components/threat_match_query_edit/translations");
var _translations10 = require("../../../rule_creation/components/threat_match_index_edit/translations");
var _translations11 = require("../../../rule_creation/components/threat_match_indicator_path_edit/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/description_step/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DescriptionListContainer = (0, _styledComponents.default)(_eui.EuiDescriptionList)`
  max-width: 600px;

  .euiDescriptionList__description {
    overflow-wrap: anywhere;
  }
`;
const DESCRIPTION_LIST_COLUMN_WIDTHS = ['50%', '50%'];
const StepRuleDescriptionComponent = ({
  data,
  columns = 'multi',
  indexPatterns,
  schema
}) => {
  const kibana = (0, _kibana.useKibana)();
  const license = (0, _use_license.useLicense)();
  const [filterManager] = (0, _react.useState)(new _public.FilterManager(kibana.services.uiSettings));
  const keys = Object.keys(schema);
  const listItems = keys.reduce((acc, key) => {
    if (key === 'machineLearningJobId') {
      return [...acc, (0, _build_ml_jobs_description.buildMlJobsDescription)((0, _fp.get)(key, data), _translations6.MACHINE_LEARNING_JOB_ID_LABEL)];
    }
    if (key === 'throttle') {
      return [...acc, (0, _throttle_description.buildThrottleDescription)((0, _fp.get)(key, data), (0, _fp.get)([key, 'label'], schema))];
    }
    if (key === 'actions') {
      return [...acc, (0, _actions_description.buildActionsDescription)((0, _fp.get)(key, data), (0, _fp.get)([key, 'label'], schema))];
    }
    return [...acc, ...buildListItems(data, (0, _fp.pick)(key, schema), filterManager, license, indexPatterns)];
  }, []);
  if (columns === 'multi') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 7
      }
    }, (0, _fp.chunk)(Math.ceil(listItems.length / 2), listItems).map((chunkListItems, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "listItemColumnStepRuleDescription",
      key: `description-step-rule-${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      listItems: chunkListItems,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 13
      }
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "listItemColumnStepRuleDescription",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }, columns === 'single' ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: listItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(DescriptionListContainer, {
    "data-test-subj": "singleSplitStepRuleDescriptionList",
    type: "column",
    columnWidths: DESCRIPTION_LIST_COLUMN_WIDTHS,
    rowGutterSize: "m",
    listItems: listItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  })));
};
exports.StepRuleDescriptionComponent = StepRuleDescriptionComponent;
const StepRuleDescription = exports.StepRuleDescription = /*#__PURE__*/(0, _react.memo)(StepRuleDescriptionComponent);
const buildListItems = (data, schema, filterManager, license, indexPatterns) => Object.keys(schema).reduce((acc, field) => [...acc, ...getDescriptionItem(field, (0, _fp.get)([field, 'label'], schema), data, filterManager, license, indexPatterns)], []);
exports.buildListItems = buildListItems;
const addFilterStateIfNotThere = filters => {
  return filters.map(filter => {
    if (filter.$state == null) {
      return {
        $state: {
          store: _esQuery.FilterStateStore.APP_STATE
        },
        ...filter
      };
    } else {
      return filter;
    }
  });
};

/* eslint complexity: ["error", 25]*/
// eslint-disable-next-line complexity
exports.addFilterStateIfNotThere = addFilterStateIfNotThere;
const getDescriptionItem = (field, label, data, filterManager, license, indexPatterns) => {
  if (field === 'queryBar') {
    var _queryBar$filters, _queryBar$saved_id;
    const queryBar = (0, _fp.get)('queryBar', data);
    const filters = addFilterStateIfNotThere((_queryBar$filters = queryBar.filters) !== null && _queryBar$filters !== void 0 ? _queryBar$filters : []);
    const query = queryBar.query.query;
    const savedId = (_queryBar$saved_id = queryBar.saved_id) !== null && _queryBar$saved_id !== void 0 ? _queryBar$saved_id : '';
    const savedQueryName = queryBar.title;
    const ruleType = (0, _fp.get)('ruleType', data);
    const queryLabel = (0, _helpers.getQueryLabel)(ruleType);
    return (0, _helpers.buildQueryBarDescription)({
      field,
      filters,
      filterManager,
      query,
      queryLabel,
      savedId,
      savedQueryName,
      indexPatterns
    });
  } else if (field === 'responseActions') {
    return [];
  } else if (field === _alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME) {
    const ruleType = (0, _fp.get)('ruleType', data);
    const ruleCanHaveGroupByFields = (0, _utils.isSuppressionRuleConfiguredWithGroupBy)(ruleType);
    if (!ruleCanHaveGroupByFields) {
      return [];
    }
    const values = (0, _fp.get)(field, data);
    return (0, _helpers.buildAlertSuppressionDescription)(label, values, ruleType);
  } else if (field === _alert_suppression_edit.ALERT_SUPPRESSION_DURATION_TYPE_FIELD_NAME) {
    return [];
  } else if (field === _alert_suppression_edit.ALERT_SUPPRESSION_DURATION_FIELD_NAME) {
    const ruleType = (0, _fp.get)('ruleType', data);
    const ruleCanHaveDuration = (0, _utils.isSuppressionRuleConfiguredWithDuration)(ruleType);
    if (!ruleCanHaveDuration) {
      return [];
    }

    // threshold rule has suppression duration without grouping fields, but suppression should be explicitly enabled by user
    // query rule have suppression duration only if group by fields selected
    const showDuration = (0, _utils.isThresholdRule)(ruleType) ? (0, _fp.get)(_threshold_alert_suppression_edit.THRESHOLD_ALERT_SUPPRESSION_ENABLED, data) === true : (0, _fp.get)(_alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME, data).length > 0;
    if (showDuration) {
      const value = (0, _fp.get)(field, data);
      return (0, _helpers.buildAlertSuppressionWindowDescription)(label, value, (0, _fp.get)(_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_TYPE_FIELD_NAME, data), ruleType);
    } else {
      return [];
    }
  } else if (field === _alert_suppression_edit.ALERT_SUPPRESSION_MISSING_FIELDS_FIELD_NAME) {
    const ruleType = (0, _fp.get)('ruleType', data);
    const ruleCanHaveSuppressionMissingFields = (0, _utils.isSuppressionRuleConfiguredWithMissingFields)(ruleType);
    if (!ruleCanHaveSuppressionMissingFields) {
      return [];
    }
    if ((0, _fp.get)(_alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME, data).length > 0) {
      const value = (0, _fp.get)(field, data);
      return (0, _helpers.buildAlertSuppressionMissingFieldsDescription)(label, value, ruleType);
    } else {
      return [];
    }
  } else if (field === 'eqlOptions') {
    const eqlOptions = (0, _fp.get)(field, data);
    return (0, _helpers.buildEqlOptionsDescription)(eqlOptions);
  } else if (field === 'threat') {
    const threats = (0, _fp.get)(field, data);
    return (0, _helpers.buildThreatDescription)({
      label,
      threat: (0, _helpers2.filterEmptyThreats)(threats)
    });
  } else if (field === 'threshold') {
    const threshold = (0, _fp.get)(field, data);
    return (0, _helpers.buildThresholdDescription)(_translations3.THRESHOLD_VALUE_LABEL, threshold);
  } else if (field === 'references') {
    const urls = (0, _fp.get)(field, data);
    return (0, _helpers.buildUrlsDescription)(label, urls);
  } else if (field === 'falsePositives') {
    const values = (0, _fp.get)(field, data);
    return (0, _helpers.buildUnorderedListArrayDescription)(label, field, values);
  } else if (field === 'investigationFields') {
    const values = (0, _fp.get)(field, data);
    return (0, _helpers.buildHighlightedFieldsOverrideDescription)(label, values);
  } else if (field === 'riskScore') {
    const values = (0, _fp.get)(field, data);
    return (0, _helpers.buildRiskScoreDescription)(values);
  } else if (field === 'severity') {
    const values = (0, _fp.get)(field, data);
    return (0, _helpers.buildSeverityDescription)(values);
  } else if (field === 'requiredFields') {
    const requiredFields = (0, _fp.get)(field, data);
    return (0, _helpers.buildRequiredFieldsDescription)(label, requiredFields);
  } else if (field === 'relatedIntegrations') {
    const relatedIntegrations = (0, _fp.get)(field, data);
    return (0, _integrations_description.buildRelatedIntegrationsDescription)(label, relatedIntegrations);
  } else if (field === 'timeline') {
    var _timeline$title;
    const timeline = (0, _fp.get)(field, data);
    return [{
      title: label,
      description: (_timeline$title = timeline.title) !== null && _timeline$title !== void 0 ? _timeline$title : _translations.DEFAULT_TIMELINE_TITLE
    }];
  } else if (field === 'note') {
    const val = (0, _fp.get)(field, data);
    return (0, _helpers.buildNoteDescription)(label, val);
  } else if (field === 'setup') {
    const val = (0, _fp.get)(field, data);
    return (0, _helpers.buildSetupDescription)(label, val);
  } else if (field === 'ruleType') {
    const ruleType = (0, _fp.get)(field, data);
    return (0, _helpers.buildRuleTypeDescription)(label, ruleType);
  } else if (field === 'kibanaSiemAppUrl') {
    return [];
  } else if (field === 'threatIndex') {
    const values = (0, _fp.get)(field, data);
    return (0, _helpers.buildStringArrayDescription)(_translations10.THREAT_MATCH_INDEX_FIELD_LABEL, field, values);
  } else if (field === 'threatQueryBar') {
    var _threatQueryBar$filte, _threatQueryBar$saved;
    const threatQueryBar = (0, _fp.get)('threatQueryBar', data);
    return (0, _helpers.buildQueryBarDescription)({
      field,
      filters: addFilterStateIfNotThere((_threatQueryBar$filte = threatQueryBar.filters) !== null && _threatQueryBar$filte !== void 0 ? _threatQueryBar$filte : []),
      filterManager,
      query: threatQueryBar.query.query,
      queryLanguage: threatQueryBar.query.language,
      savedId: (_threatQueryBar$saved = threatQueryBar.saved_id) !== null && _threatQueryBar$saved !== void 0 ? _threatQueryBar$saved : '',
      indexPatterns,
      queryLabel: _translations9.THREAT_MATCH_QUERY_FIELD_LABEL
    });
  } else if (field === 'threatMapping') {
    const threatMap = (0, _fp.get)(field, data);
    return (0, _helpers.buildThreatMappingDescription)(_translations8.THREAT_MATCH_MAPPING_FIELD_LABEL, threatMap);
  } else if (field === 'threatIndicatorPath') {
    return [{
      title: _translations11.THREAT_MATCH_INDICATOR_PATH_FIELD_LABEL,
      description: (0, _fp.get)(field, data)
    }];
  } else if (field === 'newTermsFields') {
    const values = (0, _fp.get)(field, data);
    return (0, _helpers.buildStringArrayDescription)(_translations4.NEW_TERMS_FIELDS_LABEL, field, values);
  } else if (Array.isArray((0, _fp.get)(field, data)) && field !== 'threatMapping') {
    const values = (0, _fp.get)(field, data);
    return (0, _helpers.buildStringArrayDescription)(label, field, values);
  } else if (field === 'index') {
    if ((0, _fp.get)('dataViewId', data)) {
      return [];
    }
  } else if (field === 'isBuildingBlock') {
    return (0, _fp.get)('isBuildingBlock', data) ? [{
      title: i18n.BUILDING_BLOCK_LABEL,
      description: i18n.BUILDING_BLOCK_DESCRIPTION
    }] : [];
  } else if (['interval', 'from'].includes(field)) {
    return (0, _helpers.buildIntervalDescription)(label, (0, _fp.get)(field, data));
  } else if (field === 'maxSignals') {
    const value = (0, _fp.get)(field, data);
    return value ? [{
      title: label,
      description: value
    }] : [];
  } else if (field === 'anomalyThreshold') {
    const value = (0, _fp.get)(field, data);
    return value ? [{
      title: _translations7.ANOMALY_THRESHOLD_LABEL,
      description: value
    }] : [];
  } else if (field === 'historyWindowSize') {
    const value = (0, _fp.get)(field, data);
    return value ? [{
      title: _translations5.HISTORY_WINDOW_START_LABEL,
      description: value
    }] : [];
  }
  const description = (0, _fp.get)(field, data);
  if ((0, _fp.isNumber)(description) || !(0, _fp.isEmpty)(description)) {
    return [{
      title: label,
      description
    }];
  }
  return [];
};
exports.getDescriptionItem = getDescriptionItem;