"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduleBulkActionModal = void 0;
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/common/components/schedule_bulk_action_modal/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MODAL_WIDTH = 600;
const ScheduleBulkActionModalComponent = ({
  onCancel,
  onConfirm,
  text,
  maxLookbackWindowDays,
  callouts
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const now = (0, _moment.default)();

  // By default we show three hours time range which user can then adjust
  const [startDate, setStartDate] = (0, _react.useState)(now.clone().subtract(3, 'h'));
  const [endDate, setEndDate] = (0, _react.useState)(now.clone());
  const isStartDateOutOfRange = now.clone().subtract(maxLookbackWindowDays, 'd').isAfter(startDate);
  const isEndDateInFuture = endDate.isAfter(now);
  const isInvalidTimeRange = startDate.isSameOrAfter(endDate);
  const isInvalid = isStartDateOutOfRange || isEndDateInFuture || isInvalidTimeRange;
  const errorMessage = (0, _react.useMemo)(() => {
    if (isStartDateOutOfRange) {
      return text.errors.startDateOutOfRange;
    }
    if (isEndDateInFuture) {
      return text.errors.endDateInFuture;
    }
    if (isInvalidTimeRange) {
      return text.errors.invalidTimeRange;
    }
    return null;
  }, [isEndDateInFuture, isInvalidTimeRange, isStartDateOutOfRange, text.errors.startDateOutOfRange, text.errors.endDateInFuture, text.errors.invalidTimeRange]);
  const handleConfirm = (0, _react.useCallback)(() => {
    onConfirm({
      startDate,
      endDate
    });
  }, [endDate, onConfirm, startDate]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 11
      }
    }, text.modalTitle)),
    titleProps: {
      id: modalTitleId,
      style: {
        width: '100%'
      }
    },
    onCancel: onCancel,
    onConfirm: handleConfirm,
    confirmButtonText: text.confirmButton,
    cancelButtonText: text.cancelButton,
    confirmButtonDisabled: isInvalid,
    css: {
      width: MODAL_WIDTH
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "schedule-bulk-action-modal-form",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "schedule-bulk-action-modal-time-range-form",
    label: text.timeRangeTitle,
    isInvalid: isInvalid,
    error: errorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
    "data-test-subj": "schedule-bulk-action-time-range",
    startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      className: "start-date-picker",
      "aria-label": "Start date range",
      selected: startDate,
      onChange: date => date && setStartDate(date),
      startDate: startDate,
      endDate: endDate,
      showTimeSelect: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 15
      }
    }),
    endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      className: "end-date-picker",
      "aria-label": "End date range",
      selected: endDate,
      onChange: date => date && setEndDate(date),
      startDate: startDate,
      endDate: endDate,
      showTimeSelect: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }))), callouts.map((callout, idx) => {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: `callout-${idx}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 13
      }
    }), callout);
  }));
};
const ScheduleBulkActionModal = exports.ScheduleBulkActionModal = /*#__PURE__*/_react.default.memo(ScheduleBulkActionModalComponent);
ScheduleBulkActionModal.displayName = 'ScheduleBulkActionModal';