"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSecurityTags = void 0;
var _react = require("react");
var _kibana = require("../../common/lib/kibana");
var _api = require("../../common/containers/tags/api");
var _use_fetch = require("../../common/hooks/use_fetch");
var _constants = require("../../../common/constants");
var _get_ramdom_color = require("../../../common/utils/get_ramdom_color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchSecurityTags = () => {
  const {
    http,
    savedObjectsTagging
  } = (0, _kibana.useKibana)().services;
  const tagCreated = (0, _react.useRef)(false);
  const {
    data: tags,
    isLoading: isLoadingTags,
    error: errorFetchTags
  } = (0, _use_fetch.useFetch)(_use_fetch.REQUEST_NAMES.SECURITY_TAGS, _api.getTagsByName, {
    initialParameters: {
      http,
      tagName: _constants.SECURITY_TAG_NAME
    }
  });
  const {
    fetch: fetchCreateTag,
    data: tag,
    isLoading: isLoadingCreateTags,
    error: errorCreateTag
  } = (0, _use_fetch.useFetch)(_use_fetch.REQUEST_NAMES.SECURITY_CREATE_TAG, _api.createTag);
  (0, _react.useEffect)(() => {
    if (savedObjectsTagging && !isLoadingTags && !errorFetchTags && tags && tags.length === 0 && !tagCreated.current) {
      tagCreated.current = true;
      fetchCreateTag({
        savedObjectsTaggingClient: savedObjectsTagging.client,
        tag: {
          name: _constants.SECURITY_TAG_NAME,
          description: _constants.SECURITY_TAG_DESCRIPTION,
          color: (0, _get_ramdom_color.getRandomColor)()
        }
      });
    }
  }, [errorFetchTags, fetchCreateTag, savedObjectsTagging, isLoadingTags, tags]);
  const tagsResult = (0, _react.useMemo)(() => {
    if (tags !== null && tags !== void 0 && tags.length) {
      return tags.map(t => ({
        id: t.id,
        type: 'tag',
        managed: t.managed,
        ...t.attributes
      }));
    }
    return tag ? [{
      type: 'tag',
      ...tag
    }] : undefined;
  }, [tags, tag]);
  return {
    tags: tagsResult,
    isLoading: isLoadingTags || isLoadingCreateTags,
    error: errorFetchTags || errorCreateTag
  };
};
exports.useFetchSecurityTags = useFetchSecurityTags;