"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardsTable = exports.DASHBOARDS_QUERY_ERROR = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_security_dashboards_table = require("../hooks/use_security_dashboards_table");
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/dashboards/components/dashboards_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DASHBOARDS_QUERY_ERROR = exports.DASHBOARDS_QUERY_ERROR = _i18n.i18n.translate('xpack.securitySolution.dashboards.queryError', {
  defaultMessage: 'Error retrieving security dashboards'
});

/** wait this many ms after the user completes typing before applying the filter input */
const INPUT_TIMEOUT = 250;
const DASHBOARDS_TABLE_SORTING = {
  sort: {
    field: 'title',
    direction: 'asc'
  }
};
const DashboardsTable = () => {
  const {
    items,
    isLoading,
    error
  } = (0, _use_security_dashboards_table.useSecurityDashboardsTableItems)();
  const columns = (0, _use_security_dashboards_table.useSecurityDashboardsTableColumns)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const [filteredItems, setFilteredItems] = (0, _react.useState)(items);
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const search = (0, _react.useMemo)(() => {
    const debouncedSetSearchQuery = (0, _lodash.debounce)(setSearchQuery, INPUT_TIMEOUT);
    return {
      onChange: ({
        queryText
      }) => {
        var _queryText$toLowerCas;
        debouncedSetSearchQuery((_queryText$toLowerCas = queryText.toLowerCase()) !== null && _queryText$toLowerCas !== void 0 ? _queryText$toLowerCas : '');
      },
      box: {
        incremental: true
      }
    };
  }, []);
  (0, _react.useEffect)(() => {
    if (searchQuery.length === 0) {
      setFilteredItems(items);
    } else {
      setFilteredItems(items.filter(({
        title,
        description
      }) => {
        const normalizedName = `${title} ${description}`.toLowerCase();
        return normalizedName.includes(searchQuery.replace(/[^\w- ]/g, ''));
      }));
    }
  }, [items, searchQuery]);
  (0, _react.useEffect)(() => {
    if (error) {
      addError(error, {
        title: DASHBOARDS_QUERY_ERROR
      });
    }
  }, [error, addError]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "dashboardsTable",
    items: filteredItems,
    columns: columns,
    search: search,
    pagination: true,
    sorting: DASHBOARDS_TABLE_SORTING,
    loading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  });
};
exports.DashboardsTable = DashboardsTable;