"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMiddlewares = createMiddlewares;
var _toolkit = require("@reduxjs/toolkit");
var _create_timeline_middlewares = require("../../timelines/store/middlewares/create_timeline_middlewares");
var _middleware_local_storage = require("./data_table/middleware_local_storage");
var _middleware_storage = require("../../explore/users/store/middleware_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const listenerMiddleware = (0, _toolkit.createListenerMiddleware)();
function createMiddlewares(kibana, storage) {
  return [listenerMiddleware.middleware, (0, _middleware_local_storage.dataTableLocalStorageMiddleware)(storage), (0, _middleware_storage.userAssetTableLocalStorageMiddleware)(storage), ...(0, _create_timeline_middlewares.createTimelineMiddlewares)(kibana)];
}