"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  substateMiddlewareFactory: true,
  createStoreFactory: true,
  createStore: true,
  getStore: true
};
Object.defineProperty(exports, "createStore", {
  enumerable: true,
  get: function () {
    return _store.createStore;
  }
});
Object.defineProperty(exports, "createStoreFactory", {
  enumerable: true,
  get: function () {
    return _store.createStoreFactory;
  }
});
Object.defineProperty(exports, "getStore", {
  enumerable: true,
  get: function () {
    return _store.getStore;
  }
});
exports.substateMiddlewareFactory = void 0;
var _model = require("./model");
Object.keys(_model).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _model[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _model[key];
    }
  });
});
var _reducer = require("./reducer");
Object.keys(_reducer).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _reducer[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _reducer[key];
    }
  });
});
var _selectors = require("./selectors");
Object.keys(_selectors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _selectors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _selectors[key];
    }
  });
});
var _store = require("./store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Takes a selector and an `ImmutableMiddleware`. The
 * middleware's version of `getState` will receive
 * the result of the selector instead of the global state.
 *
 * This allows middleware to have knowledge of only a subsection of state.
 *
 * `selector` returns an `Immutable` version of the substate.
 * `middleware` must be an `ImmutableMiddleware`.
 *
 * Returns a regular middleware, meant to be used with `applyMiddleware`.
 */
const substateMiddlewareFactory = (selector, middleware) => {
  return api => {
    const substateAPI = {
      ...api,
      // Return the substate instead of global state.
      getState() {
        /**
         * The selector will receive the basic (mutable) version of state. This is because
         * the top level state shape doesn't use `Immutable`. We cast the return value as `Immutable`
         * so that the middleware won't be able to mutate state.
         *
         * Immutable enforces nothing structural about a type so casting
         * a value as `Immutable` is safe as long as nothing else is going to mutate.
         * Since the state came from the return value of a reducer, the reducer will (hopefully)
         * not be mutating it.
         */
        return selector(api.getState());
      }
    };
    return middleware(substateAPI);
  };
};
exports.substateMiddlewareFactory = substateMiddlewareFactory;