"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertConfigIdByScopeId = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ScopeIdLinkToAlertTableConfiguration = {
  [_securitysolutionDataTable.TableId.alertsOnAlertsPage]: _constants.ALERTS_TABLE_REGISTRY_CONFIG_IDS.ALERTS_PAGE,
  [_securitysolutionDataTable.TableId.alertsOnRuleDetailsPage]: _constants.ALERTS_TABLE_REGISTRY_CONFIG_IDS.RULE_DETAILS,
  [_securitysolutionDataTable.TableId.alertsOnCasePage]: _constants.ALERTS_TABLE_REGISTRY_CONFIG_IDS.CASE,
  [_securitysolutionDataTable.TableId.alertsRiskInputs]: _constants.ALERTS_TABLE_REGISTRY_CONFIG_IDS.RISK_INPUTS
};
const getAlertConfigIdByScopeId = scopeId => {
  if (ScopeIdLinkToAlertTableConfiguration[scopeId]) {
    return ScopeIdLinkToAlertTableConfiguration[scopeId];
  }
  return undefined;
};
exports.getAlertConfigIdByScopeId = getAlertConfigIdByScopeId;