"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventLogTelemetryEvents = exports.eventLogShowSourceEventDateRangeEvent = exports.eventLogFilterByRunTypeEvent = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const eventLogFilterByRunTypeEvent = exports.eventLogFilterByRunTypeEvent = {
  eventType: _types.EventLogEventTypes.EventLogFilterByRunType,
  schema: {
    runType: {
      type: 'array',
      items: {
        type: 'keyword',
        _meta: {
          description: 'Filter event log by run type'
        }
      }
    }
  }
};
const eventLogShowSourceEventDateRangeEvent = exports.eventLogShowSourceEventDateRangeEvent = {
  eventType: _types.EventLogEventTypes.EventLogShowSourceEventDateRange,
  schema: {
    isVisible: {
      type: 'boolean',
      _meta: {
        description: 'Show source event date range',
        optional: false
      }
    }
  }
};
const eventLogTelemetryEvents = exports.eventLogTelemetryEvents = [eventLogFilterByRunTypeEvent, eventLogShowSourceEventDateRangeEvent];