"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostPlatform = void 0;
var _lodash = require("lodash");
var _ = require("..");
var _get_event_details_field_values = require("./get_event_details_field_values");
var _constants = require("../../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isTimelineEventDetailsItems = data => {
  return Array.isArray(data);
};

// The list of ECS fields we check to try and determine the OS type
const ECS_OS_TYPE_FIELDS = Object.freeze(['host.os.type', 'host.os.name', 'host.os.platform']);

/**
 * Retrieve a host's platform type from either ECS data or Event Details list of items
 * @param data
 */
const getHostPlatform = data => {
  let platform = '';
  for (const field of ECS_OS_TYPE_FIELDS) {
    let fieldValue = '';
    if (isTimelineEventDetailsItems(data)) {
      fieldValue = (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
        category: (0, _.parseEcsFieldPath)(field).category,
        field
      }, data).toLowerCase();
    } else {
      fieldValue = (0, _lodash.get)(data, field, '').toLowerCase();
    }
    if (_constants.SUPPORTED_HOST_OS_TYPE.includes(fieldValue)) {
      platform = fieldValue;
      break;
    }
  }
  return platform;
};
exports.getHostPlatform = getHostPlatform;