"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithCopyToClipboard = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _accessibility = require("../../components/accessibility");
var i18n = _interopRequireWildcard(require("../../components/drag_and_drop/translations"));
var _clipboard = require("./clipboard");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/lib/clipboard/with_copy_to_clipboard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Renders `children` with an adjacent icon that when clicked, copies `text` to
 * the clipboard and displays a confirmation toast
 */
const WithCopyToClipboard = exports.WithCopyToClipboard = /*#__PURE__*/_react.default.memo(({
  isHoverAction,
  keyboardShortcut = '',
  text,
  titleSummary
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: /*#__PURE__*/_react.default.createElement(_accessibility.TooltipWithKeyboardShortcut, {
    additionalScreenReaderOnlyContext: text,
    content: i18n.COPY_TO_CLIPBOARD,
    shortcut: keyboardShortcut,
    showShortcut: keyboardShortcut !== '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_clipboard.Clipboard, {
  content: text,
  isHoverAction: isHoverAction,
  titleSummary: titleSummary,
  toastLifeTimeMs: 800,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 5
  }
})));
WithCopyToClipboard.displayName = 'WithCopyToClipboard';