"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Clipboard = exports.COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME = void 0;
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _copyToClipboard = _interopRequireDefault(require("copy-to-clipboard"));
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../hooks/use_app_toasts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/lib/clipboard/clipboard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME = exports.COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME = 'copy-to-clipboard';
const Clipboard = ({
  children,
  content,
  isHoverAction,
  onCopy,
  titleSummary,
  toastLifeTimeMs
}) => {
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const onClick = event => {
    event.preventDefault();
    event.stopPropagation();
    const isSuccess = (0, _copyToClipboard.default)(`${content}`, {
      debug: true
    });
    if (onCopy != null) {
      onCopy({
        content,
        isSuccess
      });
    }
    if (isSuccess) {
      addSuccess(`${i18n.COPIED} ${titleSummary} ${i18n.TO_THE_CLIPBOARD}`, {
        toastLifeTimeMs
      });
    }
  };
  const className = (0, _classnames.default)(COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME, {
    // eslint-disable-next-line @typescript-eslint/naming-convention
    securitySolution__hoverActionButton: isHoverAction
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.COPY_TO_THE_CLIPBOARD,
    className: className,
    "data-test-subj": "clipboard",
    iconType: "copyClipboard",
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, children);
};
exports.Clipboard = Clipboard;