"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CapabilitiesChecker = void 0;
var _has_capabilities = require("./has_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * class to check if capabilities are granted using the `RequiredCapabilities` format.
 */
class CapabilitiesChecker {
  constructor(capabilities) {
    this.capabilities = capabilities;
  }
  has(requiredCapabilities) {
    return (0, _has_capabilities.hasCapabilities)(this.capabilities, requiredCapabilities);
  }
}
exports.CapabilitiesChecker = CapabilitiesChecker;