"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShallowEqualSelector = exports.useDeepEqualSelector = void 0;
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useShallowEqualSelector = selector => (0, _reactRedux.useSelector)(selector, _reactRedux.shallowEqual);
exports.useShallowEqualSelector = useShallowEqualSelector;
const useDeepEqualSelector = selector => (0, _reactRedux.useSelector)(selector, _fastDeepEqual.default);
exports.useDeepEqualSelector = useDeepEqualSelector;