"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddIntegrationsUrl = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _constants = require("../../../common/constants");
var _helpers = require("../../helpers");
var _kibana = require("../lib/kibana");
var _capabilities = require("../lib/capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddIntegrationsUrl = () => {
  const {
    http: {
      basePath: {
        prepend
      }
    },
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    navigateTo
  } = (0, _securitySolutionNavigation.useNavigateTo)();
  const isThreatIntelligence = (0, _helpers.isThreatIntelligencePath)(pathname);
  const shouldGoToConfigurations = (0, _capabilities.hasCapabilities)(capabilities, [[`${_constants.SECURITY_FEATURE_ID}.configurations`]]);
  const integrationsUrl = isThreatIntelligence ? _constants.ADD_THREAT_INTELLIGENCE_DATA_PATH : shouldGoToConfigurations ? _constants.CONFIGURATIONS_INTEGRATIONS_PATH : _constants.ADD_DATA_PATH;
  const href = (0, _react.useMemo)(() => prepend(integrationsUrl), [prepend, integrationsUrl]);
  const onClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    navigateTo({
      url: href
    });
  }, [href, navigateTo]);
  return {
    href,
    onClick
  };
};
exports.useAddIntegrationsUrl = useAddIntegrationsUrl;