"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGlobalTime = void 0;
var _fp = require("lodash/fp");
var _react = require("react");
var _reactRedux = require("react-redux");
var _constants = require("../../store/inputs/constants");
var _use_selector = require("../../hooks/use_selector");
var _store = require("../../store");
var _actions = require("../../store/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGlobalTime = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    from,
    to
  } = (0, _use_selector.useDeepEqualSelector)(state => (0, _fp.pick)(['from', 'to'], _store.inputsSelectors.globalTimeRangeSelector(state)));
  const [isInitializing, setIsInitializing] = (0, _react.useState)(true);
  const queryId = (0, _react.useRef)([]);
  const setQuery = (0, _react.useCallback)(({
    id,
    inspect,
    loading,
    refetch,
    searchSessionId
  }) => {
    queryId.current = [...queryId.current, id];
    dispatch(_actions.inputsActions.setQuery({
      inputId: _constants.InputsModelId.global,
      id,
      inspect,
      loading,
      refetch,
      searchSessionId
    }));
  }, [dispatch]);
  const deleteQuery = (0, _react.useCallback)(({
    id
  }) => dispatch(_actions.inputsActions.deleteOneQuery({
    inputId: _constants.InputsModelId.global,
    id
  })), [dispatch]);
  (0, _react.useEffect)(() => {
    setIsInitializing(false);
  }, []);

  // This effect must not have any mutable dependencies. Otherwise, the cleanup function gets called before the component unmounts.
  (0, _react.useEffect)(() => {
    return () => {
      if (queryId.current.length > 0) {
        queryId.current.forEach(id => deleteQuery({
          id
        }));
      }
    };
  }, [deleteQuery]);
  return (0, _react.useMemo)(() => ({
    isInitializing,
    from,
    to,
    setQuery,
    deleteQuery
  }), [deleteQuery, from, isInitializing, setQuery, to]);
};
exports.useGlobalTime = useGlobalTime;